package com.liquidnet.service.feign.adam.admin.user;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.query.AdamUserQuery;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_ADMIN_USER)
public interface FeignAdminAdamUserInfoClient {

    @PostMapping(value =  "/admin/adam-user/list")
    ResponseDto<Page<AdamUser>> listAdamUser(@RequestBody AdamUserQuery adamUserQuery,
                                             @RequestParam("pageNum") int pageNum,
                                             @RequestParam("pageSize") int pageSize);

}
