package com.liquidnet.service.feign.adam.task;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_TASK_CONVERSION)
public interface FeignTaskAdamConversionClient {

    @PostMapping(value = "/task/adam-conversion/send_confirm_task")
    ResponseDto sendConfirmTask();

}
