package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSpecValueVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSpecVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsCouponAddParam", description = "商品管理:添加券类商品入参")
@Data
public class GoblinStoreMgtGoodsCouponAddParam implements Serializable {
    private static final long serialVersionUID = -6261151635859590265L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotNull(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "商品ID[编辑时必传]")
    private String spuId;

    /**
     * ---------------------------- 基本信息 ----------------------------
     **/

    @ApiModelProperty(position = 12, required = true, value = "商品名称[36]")
    @NotBlank(message = "商品名称不能为空")
    @Size(max = 36, message = "商品名称长度超限")
    private String name;
//    @ApiModelProperty(position = 13, required = false, value = "商品名称[128]")
//    @Size(max = 128, message = "商品副名称长度超限")
//    private String subtitle;//-
//    @ApiModelProperty(position = 14, required = false, value = "商品销售价-原价[20,2]")
//    private BigDecimal sellPrice;//-

    @ApiModelProperty(position = 15, required = true, value = "商品一级分类ID[30]")
    @NotBlank(message = "商品分类ID不能为空")
    private String cateFid;
    @ApiModelProperty(position = 16, required = true, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 17, required = true, value = "商品三级分类ID[30]")
    private String cateTid;

    @ApiModelProperty(position = 18, required = false, value = "商品简介[256]", example = "商品简介...")
    @Size(max = 256, message = "商品简介内容过长")
    private String intro;

    @ApiModelProperty(position = 19, required = false, value = "商品标签列表")
    private List<String> tagList;
    @ApiModelProperty(position = 20, required = true, value = "商品图片列表")
    private List<String> imageList;
    @ApiModelProperty(position = 21, required = false, value = "商品图片封面")
    @Size(max = 256, message = "商品图片封面URL过长")
    private String coverPic;
    @ApiModelProperty(position = 22, required = false, value = "商品视频地址")
    @Size(max = 256, message = "商品视频地址URL过长")
    private String video;

    /**
     * ---------------------------- 价格库存 ----------------------------
     **/

//    @ApiModelProperty(position = 23, required = false, value = "规格展现方式[1-常规|2-组合]", allowableValues = "1,2", example = "1")
//    @NotBlank(message = "规格展现方式不能为空")
//    @Pattern(regexp = "\\b(1|2)\\b", message = "规格展现方式参数无效")
//    private String specMode;
    @ApiModelProperty(position = 24, required = false, value = "SKU规格信息[初次添加商品必填]")
//    @NotNull(message = "SKU规格信息不能为空")
    @Valid
    private GoblinStoreMgtGoodsCouponAddSkuParam skuParam;
//    @ApiModelProperty(position = 25, required = false, value = "物流模版", example = "松鼠德邦")
//    @Size(max = 50, message = "物流模版ID过长")
//    private String logisticsTemplate;//-
    @ApiModelProperty(position = 26, required = false, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_UNDER_50, message = "商品编码格式或长度有误")
    private String spuNo;
//    @ApiModelProperty(position = 26, required = false, value = "ERP类型[WANGDIAN-旺店通]")
//    @Pattern(regexp = "\\b(WANGDIAN)\\b", message = "ERP类型无效")
//    private String erpType;//-
//    @ApiModelProperty(position = 26, required = false, value = "ERP货品编号[商品对应在ERP的商品编码，默认为空]")
//    @Size(max = 40, message = "ERP货品编号长度限制40")
//    private String spuErpCode;//-

    /**
     * ---------------------------- 商品介绍 ----------------------------
     **/

    @ApiModelProperty(position = 27, required = true, value = "商品详情", example = "商品详情...")
    @Size(max = 10000, message = "商品详情内容过长")
    private String details;

    /**
     * ---------------------------- 销售属性 ----------------------------
     **/

    @ApiModelProperty(position = 28, required = true, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]", example = "1")
    @NotNull(message = "上架处理方式不能为空")
    @Pattern(regexp = "\\b(1|2|3)\\b", message = "规格展现方式参数无效")
    private String shelvesHandle;
    @ApiModelProperty(position = 29, required = false, value = "预约上架时间[yyyy-MM-dd HH:mm:ss][上架处理方式为3-预约定时上架时需要指定]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "预约上架时间格式有误")
    private String shelvesTime;
//    @ApiModelProperty(position = 30, required = false, value = "商品有效期[yyyy-MM-dd]")
//    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "商品有效期格式有误")
//    private String spuValidity;
//    @ApiModelProperty(position = 31, required = false, value = "是否虚拟商品[0-否|1-是]", allowableValues = "0,1", example = "0")
//    @Pattern(regexp = "\\b(0|1)\\b", message = "是否虚拟商品参数无效")
//    private String virtualFlg;//---默认1

    /**
     * ---------------------------- 服务保障 ----------------------------
     **/

    @ApiModelProperty(position = 32, required = false, value = "商品服务支持ID列表")
    private List<String> ssidList;

    /**
     * ---------------------------- 专属标签 ----------------------------
     **/

    @ApiModelProperty(position = 33, required = false, value = "商品关联音乐人、艺术家、品牌方、厂牌列表")
    private List<String> extagList;

    /**
     * ---------------------------- AR标签 ----------------------------
     **/

    @ApiModelProperty(position = 33, required = false, value = "商品关联音乐人、艺术家、品牌方、厂牌、AR列表")
    private List<String> artagList;

    /**
     * 生成券类SPU
     *
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo initGoodsInfoVo(String currentUid, LocalDateTime nowTime) {
        GoblinGoodsInfoVo vo = GoblinGoodsInfoVo.getNew();
        vo.setStoreId(this.getStoreId());
        if (StringUtils.isBlank(this.getSpuId())) {
            vo.setSpuId(IDGenerator.nextMilliId2());
        } else {
            vo.setSpuId(this.getSpuId());
        }
        if (StringUtils.isBlank(this.getSpuNo())) {
            vo.setSpuNo(vo.getSpuId());
        } else {
            vo.setSpuNo(this.getSpuNo());
        }
        vo.setSpuType(2);
        vo.setName(this.getName());
//        vo.setSubtitle(this.getSubtitle());
//        vo.setSellPrice(this.getSellPrice());
//        vo.setPriceGe(BigDecimal.ZERO);
//        vo.setPriceLe(BigDecimal.ZERO);
        vo.setIntro(this.getIntro());
        vo.setDetails(this.getDetails());
        vo.setCoverPic(StringUtils.isBlank(this.getCoverPic()) ? this.getImageList().get(0) : this.getCoverPic());
        vo.setVideo(this.getVideo());
        vo.setSpecMode("1");
        vo.setCateFid(this.getCateFid());
        vo.setCateSid(this.getCateSid());
        vo.setCateTid(this.getCateTid());
        vo.setShelvesHandle(this.getShelvesHandle());
        vo.setShelvesTime(this.getShelvesTime());
//        vo.setSpuValidity(this.getSpuValidity());
        vo.setVirtualFlg("1");
        vo.setStatus("3");
//        vo.setReason(null);
//        vo.setShelvesStatus("0");
        if (vo.getShelvesHandle().equals("2")) {
            vo.setShelvesStatus("3");// `上架处理方式`:2-直接上架售卖，直接上架
            vo.setShelvesAt(LocalDateTime.now());
        } else {
            vo.setShelvesStatus("0");
        }
        vo.setSpuAppear("0");
        vo.setDelFlg("0");
//        vo.setShelvesAt(null);
        vo.setImageList(this.getImageList());
        vo.setLogisticsTemplate("");
        vo.setCreatedBy(currentUid);
        vo.setCreatedAt(nowTime);
//        vo.setUpdatedBy();
//        vo.setUpdatedAt();
//        vo.setSpecVoList();
//        vo.setTagVoList();
//        vo.setServiceSupportVoList();
//        vo.setExtagVoList();
//        vo.setErpType(StringUtils.isBlank(this.getErpType()) ? "WANGDIAN" : this.getErpType());
//        vo.setSpuErpCode(StringUtils.trim(this.getSpuErpCode()));
        return vo;
    }



    /**
     * 编辑SPU参数整理
     *
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo initEditGoodsInfoVo() {
        GoblinGoodsInfoVo vo = GoblinGoodsInfoVo.getNew();
        vo.setStoreId(this.getStoreId());
        vo.setSpuId(this.getSpuId());
        vo.setSpuNo(this.getSpuNo());
        vo.setSpuType(2);
        vo.setName(this.getName());
//        vo.setSubtitle(this.getSubtitle());
//        vo.setSellPrice(this.getSellPrice());
        vo.setIntro(this.getIntro());
        vo.setDetails(this.getDetails());
        vo.setCoverPic(StringUtils.isBlank(this.getCoverPic()) ? this.getImageList().get(0) : this.getCoverPic());
        vo.setVideo(this.getVideo());
        vo.setSpecMode("1");
        vo.setCateFid(this.getCateFid());
        vo.setCateSid(this.getCateSid());
        vo.setCateTid(this.getCateTid());
        vo.setShelvesHandle(this.getShelvesHandle());
        vo.setShelvesTime(this.getShelvesTime());
//        vo.setSpuValidity(this.getSpuValidity());
        vo.setVirtualFlg("1");
        vo.setImageList(this.getImageList());
        vo.setLogisticsTemplate("");
//        vo.setErpType();// 暂不考虑更改ERP类型
//        vo.setSpuErpCode(StringUtils.trim(this.getSpuErpCode()));
        return vo;
    }

    /**
     * 生成SKU列表以及SPU规格等信息
     *
     * @param goodsInfoVo  GoblinGoodsInfoVo
     * @param vos          List<GoblinGoodsSkuInfoVo>
     * @param goodsSpecVos List<GoblinGoodsSpecVo>
     */
    public void initGoodsSkuInfoVo(GoblinGoodsInfoVo goodsInfoVo, List<GoblinGoodsSkuInfoVo> vos,
                                   List<GoblinGoodsSpecVo> goodsSpecVos) {
        GoblinGoodsSkuInfoVo skuInfoVo = GoblinGoodsSkuInfoVo.getNew();
        GoblinStoreMgtGoodsCouponAddSkuParam addSkuParam = this.getSkuParam();
        {// 券信息设置
            skuInfoVo.setIsTrueName(null == addSkuParam.getIsTrueName() ? 1 : Integer.valueOf(addSkuParam.getIsTrueName()));// 券类商品默认需要实名登记
            skuInfoVo.setBusiType(1);// 业务类别暂时只支持演出
            skuInfoVo.setCouType(1);// 券类型暂时只支持代金券
            skuInfoVo.setUseScope(Integer.valueOf(addSkuParam.getUseScope()));
            skuInfoVo.setValFace(addSkuParam.getValFace());
            skuInfoVo.setValidity(-1);
            skuInfoVo.setEffectAt(DateUtil.Formatter.yyyyMMddHHmmss.parse(addSkuParam.getEffectAt()));
            skuInfoVo.setExpireAt(DateUtil.Formatter.yyyyMMddHHmmss.parse(addSkuParam.getExpireAt()));
        }
        if (StringUtils.isBlank(addSkuParam.getSkuId())) {
            skuInfoVo.setSkuId(goodsInfoVo.getSpuId().concat(StringUtils.right(String.valueOf(System.nanoTime()), 5)));
        } else {
            skuInfoVo.setSkuId(addSkuParam.getSkuId());
        }
        skuInfoVo.setSpuId(goodsInfoVo.getSpuId());
//        if (StringUtils.isNotBlank(addSkuParam.getSkuNo())) {
//            skuInfoVo.setSkuNo(addSkuParam.getSkuNo());
//        } else {
            skuInfoVo.setSkuNo(goodsInfoVo.getSpuNo());
//        }
//        if (StringUtils.isNotBlank(addSkuParam.getSkuBarCode())) {
//            skuInfoVo.setSkuBarCode(addSkuParam.getSkuBarCode());
//        } else {
            skuInfoVo.setSkuBarCode(goodsInfoVo.getSpuNo());
//        }
        skuInfoVo.setSkuType(2);
        skuInfoVo.setName("张");
        skuInfoVo.setSubtitle(goodsInfoVo.getSubtitle());
        skuInfoVo.setSkuPic("");
        skuInfoVo.setSkuIsbn("");
        skuInfoVo.setStock(addSkuParam.getStock());
        skuInfoVo.setSkuStock(skuInfoVo.getStock());
//        skuInfoVo.setWarningStock(addSkuParam.getWarningStock());
//        skuInfoVo.setSellPrice(addSkuParam.getSellPrice());
        skuInfoVo.setPrice(addSkuParam.getPrice());
//        skuInfoVo.setPriceMember(null == addSkuParam.getPriceMember() ? addSkuParam.getPrice() : addSkuParam.getPriceMember());
        skuInfoVo.setPriceMember(addSkuParam.getPrice());
//        skuInfoVo.setWeight(addSkuParam.getWeight());
//        skuInfoVo.setBuyFactor(addSkuParam.getBuyFactor());
        skuInfoVo.setBuyFactor("0");
//        skuInfoVo.setBuyRoster(addSkuParam.getBuyRoster());
        skuInfoVo.setBuyLimit(addSkuParam.getBuyLimit());
        skuInfoVo.setStoreId(goodsInfoVo.getStoreId());
//        skuInfoVo.setSkuValidity(DateUtil.Formatter.yyyyMMddHHmmss.parse(addSkuParam.getSkuValidity()));
        skuInfoVo.setVirtualFlg("1");
        skuInfoVo.setStatus("3");// 没有审核流程，默认通过
//        skuInfoVo.setReason();
        skuInfoVo.setShelvesStatus(goodsInfoVo.getShelvesStatus());
        skuInfoVo.setSkuAppear(StringUtils.isBlank(addSkuParam.getSkuAppear()) ? "0" : addSkuParam.getSkuAppear());
        skuInfoVo.setDelFlg("0");
//        skuInfoVo.setShelvesAt();
        skuInfoVo.setCreatedBy(goodsInfoVo.getCreatedBy());
        skuInfoVo.setCreatedAt(goodsInfoVo.getCreatedAt());
//        skuInfoVo.setUpdatedBy();
//        skuInfoVo.setUpdatedAt();
        skuInfoVo.setLogisticsTemplate("");
//        skuInfoVo.setSkuErpCode(StringUtils.trim(addSkuParam.getSkuErpCode()));
        skuInfoVo.setErpType(goodsInfoVo.getErpType());
//        skuInfoVo.setErpWarehouseNo(StringUtils.trim(addSkuParam.getErpWarehouseNo()));
//        if (StringUtils.equals(addSkuParam.getErpHosting(), "1")) {
//            skuInfoVo.setErpHosting(1);
//            if (StringUtils.isBlank(goodsInfoVo.getSpuErpCode())) {
//                ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("149022");
//                throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
//            }
//            if (StringUtils.isBlank(skuInfoVo.getSkuErpCode())) {
//                ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("149023");
//                throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
//            }
//            if (StringUtils.isBlank(skuInfoVo.getErpWarehouseNo())) {
//                ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("149024");
//                throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
//            }
//        } else {
            skuInfoVo.setErpHosting(0);
//        }

        {// 规格信息处理
            // 券类商品固定规格
            GoblinGoodsSpecDto goblinGoodsSpecDto = GoblinGoodsSpecDto.getNew();
            goblinGoodsSpecDto.setSpecName("规格");
            goblinGoodsSpecDto.setSpecVname("张");

            // SKU规格设置
            List<GoblinGoodsSpecDto> skuSpecList = new ArrayList<>();
            skuSpecList.add(goblinGoodsSpecDto);
            skuInfoVo.setSkuSpecList(skuSpecList);

            // SPU规格集合
            GoblinGoodsSpecValueVo specValueVo = GoblinGoodsSpecValueVo.getNew().setSpecVname(goblinGoodsSpecDto.getSpecVname()).setSpecVsort(0);
            ArrayList<GoblinGoodsSpecValueVo> specValueVos = new ArrayList<>();
            specValueVos.add(specValueVo);
            goodsSpecVos.add(GoblinGoodsSpecVo.getNew().setSpecName(goblinGoodsSpecDto.getSpecName()).setSpecSort(0).setSpecValues(specValueVos));
        }

        vos.add(skuInfoVo);

        List<String> skuIdList = CollectionUtil.arrayListString();
        skuIdList.add(skuInfoVo.getSkuId());

        goodsInfoVo.setPriceGe(skuInfoVo.getPrice());
        goodsInfoVo.setPriceLe(skuInfoVo.getPrice());
        goodsInfoVo.setSpecVoList(goodsSpecVos);
        goodsInfoVo.setSkuIdList(skuIdList);
    }
}
