package com.liquidnet.service.stone.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.service.IStoneScoreUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "积分-用户相关")
@RestController
@RequestMapping("user")
@Validated
public class StoneUserController {

    @Autowired
    IStoneScoreUserService stoneScoreUserService;

    @GetMapping("info")
    @ApiOperation("积分商品列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<StoneScoreListDto> stoneUserInfo() {
        return ResponseDto.success(stoneScoreUserService.stoneUserInfo());
    }

}
