package com.liquidnet.service.chime.test;

import com.liquidnet.common.third.easemob.util.EasemobUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.chime.biz.ChimeUserBiz;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserListQueryReqDto;
import com.liquidnet.service.chime.dto.NewPageResult;
import com.liquidnet.service.chime.service.IChimePerformanceService;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestDataUtils
 * @Package com.liquidnet.service.chime.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/12 15:44
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestDataUtils {
    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private EasemobUtil easemobUtil;

    @Autowired
    private ChimeUserBiz chimeUserBiz;

    @Autowired
    private IChimePerformanceService chimePerformanceService;

    @Test
    public void getPerformanceCount(){

    }

    @Test
    public void getUserImgList(){
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        Future future = executorService.submit(new Callable(){
            public Object call() throws Exception {
                System.out.println("Asynchronous Callable");
                return "Callable Result";
            }
        });

        try {
            System.out.println("future.get() = " + future.get());
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void createUserInfoVo(){
        ExecutorService executorService = Executors.newFixedThreadPool(200);

        long start = System.currentTimeMillis();
        for(int i=0;i<1000000;i++){
            int num = i+1;
            Future future = executorService.submit(new Callable(){
                public Object call() throws Exception {
                    ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
                    chimeUserInfoDto.setUserId("TEST"+ IDGenerator.nextTimeId());
                    chimeUserInfoDto.setPassWord("123456");
                    chimeUserInfoDto.setSex("男");
                    chimeUserInfoDto.setUserName("TestName"+num);
                    chimeUserInfoDto.setUserMobile("1381111"+num);
                    chimeUserInfoDto.setAvatar("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
                    chimeUserInfoDto.setUserCover("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
                    chimeUserInfoDto.setBirthday("2021-09-01");
                    chimeUserInfoDto.setSignature("测试签名");
                    chimeUserInfoDto.setArea("山西省 太原市 迎泽区");
                    chimeUserInfoDto.setJoinPerformanceId("-1");
//                    easemobUtil.createUser(chimeUserInfoDto.getUserId(),chimeUserInfoDto.getPassWord());
                    dataUtils.createChimeUser(chimeUserInfoDto);
                    //插入userTagMapping
                    List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
                    for(int j=0;j<5;j++){
                        ChimeUserTagsMappingVo chimeUserTagDto = ChimeUserTagsMappingVo.getNew();
                        chimeUserTagDto.setUserId(chimeUserInfoDto.getUserId());
                        chimeUserTagDto.setTagCode("tags"+(j+1));
                        chimeUserTagDto.setTagDesc("标签"+(j+1));
                        userTagList.add(chimeUserTagDto);
                    }
                    dataUtils.createUserTagMapping(userTagList);
                    return Boolean.parseBoolean("true");
                }
            });
//            Future future = executorService.submit(new Runnable() {
//                public void run() {
//                    ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
//                    chimeUserInfoDto.setUserId("TEST"+ IDGenerator.nextTimeId());
//                    chimeUserInfoDto.setPassWord("123456");
//                    chimeUserInfoDto.setSex("男");
//                    chimeUserInfoDto.setUserName("TestName"+num);
//                    chimeUserInfoDto.setUserMobile("1381111"+num);
//                    chimeUserInfoDto.setAvatar("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoDto.setUserCover("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoDto.setBirthday("2021-09-01");
//                    chimeUserInfoDto.setSignature("测试签名");
//                    chimeUserInfoDto.setArea("山西省 太原市 迎泽区");
//                    chimeUserInfoDto.setJoinPerformanceId("-1");
//                    List<ChimeUserTagDto> imgList = new ArrayList<>();
//                    for(int j=0;j<5;j++){
//                        ChimeUserTagDto chimeUserTagDto = ChimeUserTagDto.getNew();
//                        chimeUserTagDto.setUserId(chimeUserInfoDto.getUserId());
//                        chimeUserTagDto.setTagCode("tags"+(j+1));
//                        chimeUserTagDto.setTagDesc("标签"+(j+1));
//                        imgList.add(chimeUserTagDto);
//                    }
//                    chimeUserInfoDto.setUserTags(imgList);
////                    easemobUtil.createUser(chimeUserInfoDto.getUserId(),chimeUserInfoDto.getPassWord());
//                    dataUtils.createChimeUser(chimeUserInfoDto);
//                }
//            });
            try {
                System.out.println("执行第几个===="+num+" future.get()=="+future.get());
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        System.out.println("耗时："+(System.currentTimeMillis() - start)/1000 + "秒");

        executorService.shutdown();
//        EasemobUtil.createUsers();
    }

    @Test
    public void testUserList(){
        for(int i=0;i<10;i++){
            long startTime = System.currentTimeMillis();
            ChimeUserListQueryReqDto reqDto = ChimeUserListQueryReqDto.getNew();
//        reqDto.setPerformanceId("-1");
            reqDto.setPerformanceId("-1");
            reqDto.setPageNum(1);
            reqDto.setPageSize(50);
            reqDto.setOrderItem(null);
            reqDto.setOrderSc(null);
            reqDto.setSex("男");
//        reqDto.setTags("");
//        PageInfo<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
            NewPageResult<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
            long endTime = System.currentTimeMillis();
            log.info("耗时：{}ms",endTime-startTime);
        }
    }

}
