package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxySeriesInfoBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 15:03
 */
@Data
public class GalaxySeriesInfoBo implements Serializable,Cloneable {
    /**
     * 本地系列唯一标识id
     */
    private String skuId;
    /**
     * 系列名称
     */
    private String seriesName;
    /**
     * 区块链上系列ID
     */
    private String seriesId;
    private Long totalCount;
    private Long crtCount;
    private String nftUrl;
    private String publishStatus;



    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxySeriesInfoBo obj = new GalaxySeriesInfoBo();

    public static GalaxySeriesInfoBo getNew() {
        try {
            return (GalaxySeriesInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxySeriesInfoBo();
        }
    }
}
