package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinPublishBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:05
 */
@Slf4j
@Component
public class ZxinPublishBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        String author = reqDto.getAuthor();
        String name = reqDto.getName();
        String url = reqDto.getUrl();
        String displayUrl = reqDto.getDisplayUrl();

        String desc = reqDto.getDesc();
        String flag = reqDto.getFlag();
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 0;
        Long sellCount = Long.valueOf(new BigDecimal(reqDto.getSellCount()).longValue()); //积分
        /**
         * 根据sku获取系列Id
         */
        String seriesId = reqDto.getSkuId();


        //查询系列信息
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        if(!resp.isSuccess()){
            //该系列已经发行多少个nft
            Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
            log.info("系列：{} 已发行 ：{}", seriesId, crtCount);
            //设置开始索引
            seriesBeginIndex = Integer.parseInt(String.valueOf(crtCount.longValue() + 1));
        }

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(name);
        nft034ReqDto.setUrl(url);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(desc);
        nft034ReqDto.setFlag(flag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if (nft034RespDto.isSuccess()) {
            //3.1.4查询 NFT发行结果
            Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
            nft035ReqDto.setTaskId(nft034RespDto.getData().getTaskId());
            //休眠1秒钟，等待执行结果
            try {
                Thread.sleep(1000l);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            long timeStart = System.currentTimeMillis();
            log.info("=======执行第{}次查询,taskId:{}", 1, nft035ReqDto.getTaskId());
            ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDto = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);

            if (nft035RespDto.isSuccess()) {
                if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                    log.info("任务执行失败！taskId:{} taskMsg:{}", nft035ReqDto.getTaskId(), nft035RespDto.getData().getTaskMsg());
                    return null;
                }

                int count = 1;
                String nftIdBegin = nft035RespDto.getData().getNftIdBegin();

                if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())) {
                    log.info(ZxlnftEnum.TaskStatusEnum.PROCESSING.getMessage());
                    while (StringUtil.isEmpty(nftIdBegin)) {
                        //休眠1秒钟，等待执行结果
                        try {
                            Thread.sleep(1000l);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                        count++;
                        ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
                        log.info("=======执行第{}次查询,taskId:{}", count, nft035ReqDto.getTaskId());
                        if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                            nftIdBegin = nft035RespDtoTemp.getData().getNftIdBegin();
                        } else if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                            log.info("任务执行失败！taskId:{}", nft035ReqDto.getTaskId());
                            return null;
                        }

                        if (count == 6) {
                            log.info("=======查询共6次，跳出循环！taskId:{}", nft035ReqDto.getTaskId());
                            break;
                        }
                    }
                } else if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                    log.info(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getMessage());
                }

                log.info("发行NFT后返回给前端nftID:{}", nftIdBegin);
                log.info("总共执行了{}次查询 总耗时:{} MS", count, (System.currentTimeMillis() - timeStart));

                if (StringUtil.isNotEmpty(nftIdBegin)) {
                    //3.1.3调用NFT查询接口
                    Nft036InfoReqDto nft036ReqDto = Nft036InfoReqDto.getNew();
                    nft036ReqDto.setNftId(nftIdBegin);
                    ZxlnftResponseDto<Nft036InfoRespDto> nft036RespDto = zxlnftSdkUtil.nft036Info(nft036ReqDto);
                    log.info("调用NFT查询接口 : {}", nft036RespDto.toJson());
                }
            }
        }
        return null;
    }
}
