package com.liquidnet.service.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    private long keyExpireTime = 3600*24*30;

    public void setGalaxyUserInfo(String routeType,String userId, GalaxyUserInfoBo userInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId,userInfoBo,keyExpireTime);
        mongoTemplate.save(userInfoBo,GalaxyUserInfoBo.class.getSimpleName());
    }

    public GalaxyUserInfoBo getGalaxyUserInfo(String routeType,String userId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId);
        if(obj!=null){
            return (GalaxyUserInfoBo) obj;
        }else {
            GalaxyUserInfoBo userInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("userId").is(userId)), GalaxyUserInfoBo.class, GalaxyUserInfoBo.class.getSimpleName());
            if (userInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId, userInfoBo);
            return userInfoBo;
        }
    }

    public void setSeriesInfoBo(String routeType,String skuId, GalaxySeriesInfoBo seriesInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId,seriesInfoBo,keyExpireTime);
    }

    public GalaxySeriesInfoBo getSeriesInfoBo(String routeType, String skuId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesInfoBo) obj;
        }else {
            GalaxySeriesInfoBo seriesInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("skuId").is(skuId)), GalaxySeriesInfoBo.class, GalaxySeriesInfoBo.class.getSimpleName());
            if (seriesInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId, seriesInfoBo);
            return seriesInfoBo;
        }
    }

//    public void updateOrderStatus(String code, DragonOrdersDto dragonOrdersDto) {
//        redisUtil.set(GalaxyConstant.REDIS_KET_PAY_CODE + code, dragonOrdersDto,keyExpireTime);
//    }
//
//    public void setRefundNotifyUrl(String code, String notifyUrl) {
//        redisUtil.set(GalaxyConstant.REFUND_REDIS_KET + code, notifyUrl,keyExpireTime);
//    }
}
