package com.liquidnet.client.admin.zhengzai.stone.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.client.admin.zhengzai.stone.service.IScoreService;
import com.liquidnet.client.admin.zhengzai.stone.service.dto.StoneScoreListExportDto;
import com.liquidnet.client.admin.zhengzai.stone.service.utils.StoneMongoUtils;
import com.liquidnet.client.admin.zhengzai.stone.service.utils.StoneRedisUtils;
import com.liquidnet.client.admin.zhengzai.stone.service.vo.StoneUserScoreDetailVo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.entity.StoneScoreUser;
import com.liquidnet.service.stone.mapper.StoneScoreLogsMapper;
import com.liquidnet.service.stone.mapper.StoneScoreUserMapper;
import com.liquidnet.service.stone.param.StoneScoreListParam;
import com.liquidnet.service.stone.vo.StoneUserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


@Service
@Slf4j
public class ScoreServiceImpl implements IScoreService {

    @Autowired
    StoneScoreUserMapper stoneScoreUserMapper;
    @Autowired
    StoneScoreLogsMapper stoneScoreLogsMapper;
    @Autowired
    StoneRedisUtils redisUtils;
    @Autowired
    StoneMongoUtils mongoUtils;

    @Override
    public List<StoneScoreListDto> list(StoneScoreListParam param) {
        param.setUid("-999");
        List<StoneScoreListDto> dto = stoneScoreUserMapper.list(param);
        return dto;
    }

    @Override
    public List<StoneScoreListExportDto> listExport(String[] uidList) {
        List<StoneScoreListDto> list = stoneScoreUserMapper.listExport(uidList);
        List<StoneScoreListExportDto> voList = new ArrayList();
        for (StoneScoreListDto item :list){
            voList.add(StoneScoreListExportDto.getNew().copyExportVo(item));
        }
        return voList;
    }

    @Override
    public String changeStatus(String uid, Integer status) {
        if (!(status == 1 || status == 2)) {
            return "状态错误";
        }
        StoneScoreUser data = new StoneScoreUser();
        data.setStatus(status);
        int isExists = stoneScoreUserMapper.selectCount(Wrappers.lambdaQuery(StoneScoreUser.class).eq(StoneScoreUser::getUid, uid));
        int count;
        StoneUserVo vo = redisUtils.getUserData(uid);
        if (vo == null) {
            vo = StoneUserVo.getNew();
            vo.getTask();
        }
        vo.setStatus(status);
        vo.setUid(uid);
        if (isExists > 0) {
            data.setUpdatedAt(LocalDateTime.now());
            count = stoneScoreUserMapper.update(data, Wrappers.lambdaQuery(StoneScoreUser.class).eq(StoneScoreUser::getUid, uid));
            //redis
            redisUtils.setUserData(uid, vo);
            //mongo
            mongoUtils.userUpdateByUid(vo);
        } else {
            data.setScoreId(IDGenerator.nextTimeId2());
            data.setUid(uid);
            data.setCreatedAt(LocalDateTime.now());
            count = stoneScoreUserMapper.insert(data);
            //redis
            redisUtils.setUserData(uid, vo);
            //mongo
            mongoUtils.userCreate(vo);
        }
        if (count <= 0) {
            return "修改失败";
        }
        return "修改成功";
    }

    @Override
    public StoneUserScoreDetailVo userScoreDetail(String uid) {
        StoneScoreListParam param = new StoneScoreListParam();
        param.setMobile("");
        param.setUid(uid);
        StoneScoreListDto dto = stoneScoreUserMapper.detail(param);
        List<StoneScoreLogs> dataList = stoneScoreLogsMapper.selectList(Wrappers.lambdaQuery(StoneScoreLogs.class).eq(StoneScoreLogs::getUid, uid));
        StoneUserScoreDetailVo vo = new StoneUserScoreDetailVo();
        if(dataList==null || dataList.size()==0) {

        }else{
            vo.setDto(dto);
            vo.setScoreLogs(dataList);
        }
        return vo;
    }
}
