package com.liquidnet.service.candy.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.candy.constant.CandyRedisConst;
import com.liquidnet.service.candy.dto.CandyCommonCouponBasicDto;
import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
public class RedisDataUtils {

    @Autowired
    RedisUtil redisUtil;

    // 获取 CandyUserCouponBasicDto数组 根据用户id
    public List<CandyUserCouponBasicDto> getCouponByUid(String uid) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        String publicRedisKey = CandyRedisConst.BASIC_COMMON_COUPON;

        Object obj = redisUtil.get(redisKey);
        Object obj2 = redisUtil.get(publicRedisKey);

        List<CandyUserCouponBasicDto> userDto;
        List<CandyCommonCouponBasicDto> pubDto;
        if (obj == null) {
            //降级
            userDto = new ArrayList();
        } else {
            userDto = (List<CandyUserCouponBasicDto>) obj;
        }

        if (obj2 == null) {
            //降级
            pubDto = new ArrayList();
        } else {
            pubDto = (List<CandyCommonCouponBasicDto>) obj2;
        }

        boolean needSet = false;
        List<String> userIds = userDto.stream().map(CandyUserCouponBasicDto::getCcouponId).collect(Collectors.toList());
        log.info("userIds = "+userIds.toString());
        for (CandyCommonCouponBasicDto item : pubDto) {
            log.info("pubDto = "+item.getCcouponId());
            if (userIds.contains(item.getCcouponId())) {
                continue;
            } else {
                log.info("pubDto = add");
                CandyUserCouponBasicDto userCouponBasicDto = CandyUserCouponBasicDto.getNew().copyToRedisCommonBaseCoupon(IDGenerator.get32UUID(), uid, item);
                userDto.add(userCouponBasicDto);
                needSet = true;
            }
        }
        if (needSet) {
            setCouponByUid(uid, userDto);
        }
        return userDto;
    }

    // 覆盖 CandyUserCouponBasicDto数组 根据用户id
    public void setCouponByUid(String uid, List<CandyUserCouponBasicDto> dtoList) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        redisUtil.set(redisKey, dtoList);
    }

    // 添加 CandyUserCouponBasicDto数组  item
    public void addCouponByUid(String uid, CandyUserCouponBasicDto dto) {
        List<CandyUserCouponBasicDto> dtoList = getCouponByUid(uid);
        dtoList.add(dto);
        setCouponByUid(uid, dtoList);
    }

    //获取 CandyCouponCodeDto 根据 ccode
    public CandyCouponCodeDto getCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponCodeDto) obj;
        }
    }

    //删除 CandyCouponCodeDto 根据 ccode
    public void delCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        redisUtil.del(redisKey);
    }

    //获取 CandyCouponInfoDto 根据 couponId
    public CandyCouponInfoDto getCouponInfo(String couponId) {
        String redisKey = CandyRedisConst.BASIC_COUPON_INFO.concat(couponId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponInfoDto) obj;
        }
    }
}
