package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: SeriesClaimResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:44
 */
@Data
public class Nft031SeriesClaimResultRespDto implements Serializable {
    /**
     * 标记任务状态，2：任务执行中 7：任务成功 10：任务失败
     */
    private Integer taskStatus;
    /**
     * 失败情况下会有提示信息
     */
    private String taskMsg;
    /**
     * 系列ID，后面用于查询系列信息
     */
    private String seriesId;
    /**
     * 交易hash
     */
    private String txHash;
    /**
     * 链上交易时间戳
     */
    private Long chainTimestamp;

    private static final Nft031SeriesClaimResultRespDto obj = new Nft031SeriesClaimResultRespDto();
    public static Nft031SeriesClaimResultRespDto getNew() {
        try {
            return (Nft031SeriesClaimResultRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft031SeriesClaimResultRespDto();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

}
