package com.liquidnet.service.candy.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel
public class CandyUseResultVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "优惠内容",example = "1")
    private BigDecimal value;
    @ApiModelProperty(value = "券类型[-1-不可用 | 1-代金券｜2-满减券｜3-兑换券｜4-折扣券|101-优先券]",example = "1")
    private Integer couType;
    @ApiModelProperty(value = "目标数组")
    private List<String> targetIds;
    @ApiModelProperty(value = "满减金额[满多少]")
    private BigDecimal fullValue;

    private static final CandyUseResultVo obj = new CandyUseResultVo();

    public static CandyUseResultVo getNew() {
        try {
            return (CandyUseResultVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CandyUseResultVo();
    }

}
