package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 快递模板表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinExpressModule implements Serializable {

    private static final long serialVersionUID = -5081186584071376123L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * module_id
     */
    private String moduleId;

    /**
     * 快件产品名称
     */
    private String title;

    /**
     * 产品编码
     */
    private Integer productCode;

    /**
     * 时效类型
     */
    private String agingType;

    /**
     * 快递价格（预估）
     */
    private BigDecimal estimatePriceMin;

    /**
     * 快递价格（预估）
     */
    private BigDecimal estimatePriceMax;

    /**
     * 是否上线 1未上线 2已上线
     */
    private Integer isOnline;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final KylinExpressModule obj = new KylinExpressModule();

    public static KylinExpressModule getNew() {
        try {
            return (KylinExpressModule) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinExpressModule();
        }
    }


}
