package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.exception.BusinessException;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderDetailedExportVo;
import com.liquidnet.client.admin.zhengzai.sweet.dto.SweetYbActivityExportVo;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminQrCodeService;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetYbActivityService;
import com.liquidnet.client.admin.zhengzai.sweet.utils.SweetRedisAdminUtils;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateActiveQrCodeParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetYbActivityListParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetYbActivityParam;
import com.liquidnet.service.sweet.dto.vo.SweetYbActivityVo;
import com.liquidnet.service.sweet.entity.SweetQrCode;
import com.liquidnet.service.sweet.entity.SweetYbActivity;
import com.liquidnet.service.sweet.entity.SweetYbEnroll;
import com.liquidnet.service.sweet.mapper.SweetQrCodeMapper;
import com.liquidnet.service.sweet.mapper.SweetYbActivityMapper;
import com.liquidnet.service.sweet.mapper.SweetYbEnrollMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;


@Service
@Slf4j
public class SweetYbActivityServiceImpl implements ISweetYbActivityService {

    @Autowired
    SweetRedisAdminUtils sweetRedisAdminUtils;
    @Autowired
    SweetYbActivityMapper sweetYbActivityMapper;
    @Autowired
    SweetYbEnrollMapper sweetYbEnrollMapper;

    @Override
    public AjaxResult aInsert(SweetYbActivityParam param) {
        LocalDateTime now = LocalDateTime.now();
        SweetYbActivity entity = SweetYbActivity.getNew();
        entity.setActivityId(IDGenerator.nextTimeId2());
        entity.setCover(param.getCover());
        entity.setTitle(param.getTitle());
        entity.setStartTime(LocalDateTime.parse(param.getStartTime(), DTF_YMD_HMS));
        entity.setEndTime(LocalDateTime.parse(param.getEndTime(), DTF_YMD_HMS));
        entity.setStatus(7);
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        int i = sweetYbActivityMapper.insert(entity);
        if (i > 0) {
            SweetYbActivityVo vo = SweetYbActivityVo.getNew();
            vo.setCreatedAt(DateUtil.getNowTime());
            vo.setCover(entity.getCover());
            vo.setTitle(entity.getTitle());
            vo.setActivityId(entity.getActivityId());
            vo.setStartTime(entity.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            vo.setEndTime(entity.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            sweetRedisAdminUtils.setSweetYbActivityVo(vo);
            return AjaxResult.success("添加成功");
        }
        return AjaxResult.error("添加失败");
    }

    @Override
    public SweetYbActivityVo aDetails(String activityId) {
        SweetYbActivity entity = sweetYbActivityMapper.selectOne(Wrappers.lambdaQuery(SweetYbActivity.class).eq(SweetYbActivity::getActivityId, activityId));

        return initVo(entity);
    }

    @Override
    public PageInfo<SweetYbActivityVo> aList(SweetYbActivityListParam param) {
        PageInfo<SweetYbActivityVo> pageInfo;
        List<SweetYbActivity> data = sweetYbActivityMapper.selectList(Wrappers.lambdaQuery(SweetYbActivity.class).like(SweetYbActivity::getTitle, param.getTitle()));
        List<SweetYbActivityVo> voList = new ArrayList<>();
        for (SweetYbActivity entity : data) {
            SweetYbActivityVo vo = initVo(entity);
            voList.add(vo);
        }
        pageInfo = new PageInfo(voList);
        return pageInfo;
    }

    @Override
    public AjaxResult aUpdate(SweetYbActivityParam param) {
        int count = sweetYbActivityMapper.selectCount(Wrappers.lambdaQuery(SweetYbActivity.class).ne(SweetYbActivity::getActivityId, param.getActivityId()).eq(SweetYbActivity::getTitle, param.getTitle()));
        if (count > 0) {
            return AjaxResult.error("活动名称重复");
        }
        LocalDateTime now = LocalDateTime.now();
        SweetYbActivity entity = SweetYbActivity.getNew();
        entity.setCover(param.getCover());
        entity.setTitle(param.getTitle());
        entity.setStartTime(LocalDateTime.parse(param.getStartTime(), DTF_YMD_HMS));
        entity.setEndTime(LocalDateTime.parse(param.getEndTime(), DTF_YMD_HMS));
        entity.setUpdatedAt(now);
        int i = sweetYbActivityMapper.update(entity, Wrappers.lambdaUpdate(SweetYbActivity.class).eq(SweetYbActivity::getActivityId, param.getActivityId()));
        if (i > 0) {
            SweetYbActivityVo vo = sweetRedisAdminUtils.getSweetYbActivityVo(param.getActivityId());
            vo.setUpdatedAt(DateUtil.getNowTime());
            vo.setCover(entity.getCover());
            vo.setTitle(entity.getTitle());
            vo.setStartTime(entity.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            vo.setEndTime(entity.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            sweetRedisAdminUtils.setSweetYbActivityVo(vo);
            return AjaxResult.success("修改成功");
        }
        return AjaxResult.error("修改失败");
    }

    @Override
    public AjaxResult aStatus(String activityId, Integer status) {
        if (status != 6 && status != 7) {
            return AjaxResult.error("修改失败");
        }
        SweetYbActivity entity = SweetYbActivity.getNew();
        entity.setStatus(status);
        int i = sweetYbActivityMapper.update(entity, Wrappers.lambdaUpdate(SweetYbActivity.class).eq(SweetYbActivity::getActivityId, activityId));
        if (i > 0) {
            SweetYbActivityVo vo = sweetRedisAdminUtils.getSweetYbActivityVo(activityId);
            vo.setStatus(status);
            sweetRedisAdminUtils.setSweetYbActivityVo(vo);
            if (status == 6) {
                sweetRedisAdminUtils.addSweetYbActivityList(activityId);
            } else {
                sweetRedisAdminUtils.removeSweetYbActivityList(activityId);
            }
            return AjaxResult.success("修改成功");
        }
        return AjaxResult.error("修改失败");
    }

    @Override
    public List<SweetYbActivityExportVo> aExport(String activityId) {
        try {
            List<SweetYbEnroll> list = sweetYbEnrollMapper.selectList(Wrappers.lambdaQuery(SweetYbEnroll.class).eq(SweetYbEnroll::getActivityId, activityId));
            List<SweetYbActivityExportVo> voList = new ArrayList();
            for (SweetYbEnroll item : list) {
                voList.add(SweetYbActivityExportVo.getNew().copyOrderExportVo(item));
            }
            return voList;
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("导出异常，请联系网站管理员！");
        }
    }

    private SweetYbActivityVo initVo(SweetYbActivity entity) {
        LocalDateTime now = LocalDateTime.now();
        SweetYbActivityVo vo = SweetYbActivityVo.getNew();
        vo.setActivityId(entity.getActivityId());
        vo.setCreatedAt(entity.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        vo.setEndTime(entity.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        vo.setStartTime(entity.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        vo.setTitle(entity.getTitle());
        vo.setCover(entity.getCover());
        if (entity.getStatus() == 6) {
            if (now.isBefore(entity.getStartTime())) {
                vo.setStatus(0);
            } else if (now.isAfter(entity.getEndTime())) {
                vo.setStatus(9);
            } else {
                vo.setStatus(6);
            }
        } else {
            vo.setStatus(entity.getStatus());
        }
        return vo;
    }
}
