package com.liquidnet.client.admin.zhengzai.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.dto.vo.SweetYbActivityVo;
import com.liquidnet.service.sweet.entity.SweetQrCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Currency;
import java.util.LinkedList;
import java.util.List;

@Component
public class SweetRedisAdminUtils {

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public void setIntegralActivityList(List<IntegralActivityVo> voList) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LIST;
        boolean set = redisDataSourceUtil.getRedisSweetUtil().set(redisKey, voList);
    }

    public void setIntegralActivityInfo(IntegralActivityVo integralActivityVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_INFO.concat(integralActivityVo.getIntegralActivityId());
        boolean set = redisDataSourceUtil.getRedisSweetUtil().set(redisKey, integralActivityVo);
    }

    /**
     * 奖品库存
     */
    public void incrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        redisDataSourceUtil.getRedisSweetUtil().incr(redisKey, num);
    }

    public void decrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        redisDataSourceUtil.getRedisSweetUtil().decr(redisKey, num);
    }

    public void delIntegralActivityPrizeNum(String integralActivityId, String prizeId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        redisDataSourceUtil.getRedisSweetUtil().del(redisKey);
    }

    public int getIntegralActivityPrizeNum(String integralActivityId, String prizeId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public void setIntegralActivityTotalPrizeNum(String integralActivityId, int totalPrizeNum) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_TOTAL_PRIZE_NUM
                .concat(integralActivityId);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, totalPrizeNum);
    }

    public void delIntegralActivityDrawList(String uid, String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_USER_KEY)
                .concat(uid);
        redisDataSourceUtil.getRedisSweetUtil().del(redisKey);
    }

    public void setIntegralActivityDrawInfo(String drawId) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        IntegralActivityDrawVo info = (IntegralActivityDrawVo) redisDataSourceUtil.getRedisSweetUtil().get(redisKeyDraw);
        info.setReceivingStatus(2);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKeyDraw, info);
    }

    /**
     * 预估人数
     */
    public void incrIntegralActivityEstimatedNum(String integralActivityId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_ESTIMATEDNUM
                .concat(integralActivityId);
        redisDataSourceUtil.getRedisSweetUtil().incr(redisKey, num);
    }

    public void decrIntegralActivityEstimatedNum(String integralActivityId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_ESTIMATEDNUM
                .concat(integralActivityId);
        redisDataSourceUtil.getRedisSweetUtil().decr(redisKey, num);
    }

    public int getIntegralActivityEstimatedNum(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_ESTIMATEDNUM
                .concat(integralActivityId);
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    //
    public void initQrCodeReadNum(int type, String qrCodeId) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_READ_NUM.concat(type + "").concat(":qrCodeId:").concat(qrCodeId);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, 0);
    }

    public void setQrCodeReadNum(int type, String qrCodeId, int num) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_READ_NUM.concat(type + "").concat(":qrCodeId:").concat(qrCodeId);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, num);
    }

    public int getQrCodeShowNum(int type, String qrCodeId) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_SHOW_NUM.concat(type + "").concat(":qrCodeId:").concat(qrCodeId);
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public void initQrCodeShowNum(int type, String qrCodeId) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_SHOW_NUM.concat(type + "").concat(":qrCodeId:").concat(qrCodeId);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, 0);
    }

    public void setQrCodMaxNum(int type, int num) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_MAX_NUM.concat(type + "");
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, num);
    }

    public void setQrCodeDetails(int type, List<SweetQrCode> data) {
        String redisKey = SweetConstant.REDIS_KEY_QRCODE_LIST.concat(type + "");
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, data);
    }

    //yb活动vo
    public void setSweetYbActivityVo(SweetYbActivityVo vo) {
        String redisKey = SweetConstant.REDIS_KEY_YB_ACTIVITY.concat(vo.getActivityId());
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, vo);
    }

    //yb活动vo
    public SweetYbActivityVo getSweetYbActivityVo(String activityId) {
        String redisKey = SweetConstant.REDIS_KEY_YB_ACTIVITY.concat(activityId);
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (obj == null) {
            return SweetYbActivityVo.getNew();
        } else {
            return (SweetYbActivityVo) obj;
        }
    }

    //yb活动vo
    public List<String> getSweetYbActivityList() {
        String redisKey = SweetConstant.REDIS_KEY_YB_ACTIVITY_LIST;
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    //yb活动vo
    public void addSweetYbActivityList(String activityId) {
        List<String> list = getSweetYbActivityList();
        list.add(activityId);
    }

    //yb活动vo
    public void removeSweetYbActivityList(String activityId) {
        List<String> list = getSweetYbActivityList();
        list.remove(list);
    }
}
