package com.liquidnet.service.feign.kylin.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinPerformanceClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignKylinPerformanceClient {

    // 演出列表
    @GetMapping(value =  "performance/list")
    ResponseDto<List<KylinPerformanceVo>> performanceList(@RequestParam("performancesIds") String... performancesIds);
}
