package com.liquidnet.service.goblin.service.impl.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinBackOrder;
import com.liquidnet.service.goblin.entity.GoblinBackOrderLog;
import com.liquidnet.service.goblin.entity.GoblinOrderOperationLog;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreBackOrderService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

@Service
@Slf4j
public class GoblinStoreBackOrderServiceImpl implements IGoblinStoreBackOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Value("${liquidnet.service.order.url-pay.goblinRefundUrl}")
    private String synUrl;
    @Value("${liquidnet.service.dragon.urls.refundApply}")
    private String refundApply;

    @Override
    public ResponseDto<PageInfo<GoblinStoreBackOrderListVo>> orderBackList(Integer page, String orderBackCode, Integer type, String cst, String cet, String orderCode, String spuName, Integer status) {
        List<GoblinStoreBackOrderListVo> listVos = ObjectUtil.goblinStoreBackOrderListVoArrayList();
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        HashMap<String, Object> map = mongoUtils.storeBackOrderList(storeInfoVo.getStoreId(), page, orderBackCode,type, cst, cet, orderCode, spuName, status);
        long total = (long) map.get("total");
        List<GoblinBackOrderVo> voList = (List<GoblinBackOrderVo>) map.get("data");
        for (GoblinBackOrderVo item : voList) {
            GoblinStoreBackOrderListVo vo = GoblinStoreBackOrderListVo.getNew();
            vo.setCreatedAt(item.getCreatedAt());
            vo.setBackOrderId(item.getBackOrderId());
            vo.setBackCode(item.getBackCode());
            vo.setBackOrderSkuVos(item.getBackOrderSkuVos());
            vo.setOrderCode(item.getOrderCode());
            vo.setRealBackPrice(item.getBackOrderId());
            vo.setStatus(item.getBackOrderId());
            vo.setType(item.getBackOrderId());
            listVos.add(vo);
        }
        PageInfo<GoblinStoreBackOrderListVo> pageInfo = new PageInfo(listVos);
        pageInfo.setTotal(total);
        return ResponseDto.success(pageInfo);
    }

    @Override
    public ResponseDto<GoblinStoreBackOrderListVo> orderDetails(String backOrderId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinBackOrderVo orderVo = redisUtils.getBackOrderVo(backOrderId);
        GoblinStoreBackOrderListVo vo = GoblinStoreBackOrderListVo.getNew();
        vo.setCreatedAt(orderVo.getCreatedAt());
        vo.setBackOrderId(orderVo.getBackOrderId());
        vo.setBackCode(orderVo.getBackCode());
        vo.setBackOrderSkuVos(orderVo.getBackOrderSkuVos());
        vo.setOrderCode(orderVo.getOrderCode());
        vo.setRealBackPrice(orderVo.getBackOrderId());
        vo.setStatus(orderVo.getBackOrderId());
        vo.setType(orderVo.getBackOrderId());
        return ResponseDto.success(vo);
    }
}
