package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinBannersServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 轮播图 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-01
 */

@Controller
@RequestMapping("/kylin/banners")
public class KylinBannersAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/banners";

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @RequiresPermissions("kylin:banners:view")
    @GetMapping()
    public String banners() {
        return prefix + "/banners";
    }

    @GetMapping("/create")
    public String create()
    {
        return prefix + "/create";
    }

    @RequiresPermissions("kylin:banners:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(@RequestBody @Validated BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.create(bannersParam);
        if (res) {
            return success();
        } else {
            return error("添加banner失败");
        }
    }

    @GetMapping("/update/{bannersId}")
    public String update(@PathVariable("bannersId") String bannersId, ModelMap mmap)
    {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        mmap.put("KylinBannersVo", result);
        return prefix + "/update";
    }

    @RequiresPermissions("kylin:banners:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult updateSave(@RequestBody BannersParam bannersParam) {
        boolean res = kylinBannersServiceImpl.update(bannersParam);
        if (res) {
            return success();
        } else {
            return error("修改banner失败");
        }
    }

    @RequiresPermissions("kylin:banners:detail")
    @GetMapping("/details/{bannersId}")
    public String detail(@PathVariable("bannersId") String bannersId, ModelMap mmap) {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        mmap.put("KylinBannersVo", result);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:banners:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo bannerList(BannersSearchParam bannersSearchParam) {
        PageInfo<BannerDetailsListDao> result = kylinBannersServiceImpl.bannerList(bannersSearchParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:banners:delete")
    @PostMapping("delete")
    @ResponseBody
    public AjaxResult delete(BannersParam bannersParam) {
        String bannersId = bannersParam.getBannersId();
        boolean result = kylinBannersServiceImpl.delete(bannersId);
        if (result) {
            return success("删除成功");
        } else {
            return error("删除失败");
        }
    }

}
