package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;

public class CurrentUtil {
    public static final String uTag = "u-tag";
    public static final String uToken = "u-token";

    public static String getToken() {
        String authToken = ServletUtils.getRequest().getHeader(uToken);
        return StringUtils.isBlank(authToken) ? null : authToken.substring(7);
    }

    public static Map getTokenClaims() {
        return JsonUtils.fromJson(ServletUtils.getRequest().getHeader(uTag), Map.class);
    }

    public static String getCurrentUid() {
        Map tokenClaims = getTokenClaims();
        // TODO: 2021/5/14 dev联调API未启用token默认使用1
        return CollectionUtils.isEmpty(tokenClaims) ? "1" : (String) tokenClaims.get("uid");
    }
}
