package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.dto.Nft037AddressListReqDto;
import com.liquidnet.common.third.zxlnft.dto.Nft037AddressListRespDto;
import com.liquidnet.common.third.zxlnft.dto.ZxlnftResponseDto;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinTradeQueryBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 17:38
 */
@Slf4j
@Component
public class ZxinTradeQueryBiz implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        Nft037AddressListReqDto nft037ReqDto = Nft037AddressListReqDto.getNew();
        nft037ReqDto.setAddr(userInfoBo.getBlockChainAddress());
        nft037ReqDto.setSeriesId(seriesNftInfoBo.getSeriesId());
        nft037ReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft037AddressListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft037AddressList(nft037ReqDto);


        GalaxyQueryUserSeriesNftListRespDto queryNftListRespDto = GalaxyQueryUserSeriesNftListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryNftListRespDto);
            queryNftListRespDto.setUserId(reqDto.getUserId());
            queryNftListRespDto.setSeriesId(seriesNftInfoBo.getSeriesId());
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryNftListRespDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
        return null;
    }
}
