package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description: NFT兑换码表
 * @Date:Create：in 2022/4/19 1:55 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExCode implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 兑换码id
     */
    private String codeId;

    /**
     * 活动id
     */
    private String activityId;


    /**
     * 兑换码
     */
    private String code;


    /**
     * 款式id
     */
    private String skuId;


    /**
     * 兑换码状态 1 未兑换  2  已兑换
     */
    private Integer state;


    /**
     * 兑换用户id
     */
    private String redeemUid;

    /**
     * 操作用户id
     */
    private String adminUid;


    /**
     * 兑换时间
     */
    private LocalDateTime redeemAt;


    /**
     * 创建时间
     */
    private LocalDateTime createdAt;


    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 类型 默认无参 1：明盒、盲盒 2：空投盲盒/空投明盒
     */
    private Integer isDrivi;
    private String sktName;


    private static final GoblinNftExCode obj = new GoblinNftExCode();

    public static GoblinNftExCode getNew() {
        try {
            return (GoblinNftExCode) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftExCode();
        }
    }


}
