package com.liquidnet.service.merchant.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.constant.CandyRedisConst;
import com.liquidnet.service.merchant.dto.CandyCommonCouponBasicDto;
import com.liquidnet.service.merchant.dto.CandyCouponCodeDto;
import com.liquidnet.service.merchant.dto.CandyCouponInfoDto;
import com.liquidnet.service.merchant.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.feign.platform.api.FeignPlatformCandyDemoteClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
public class RedisDataUtils {

    @Autowired
    RedisUtil redisUtil;
    @Autowired
    FeignPlatformCandyDemoteClient feignPlatformCandyDemoteClient;

    // 获取 CandyUserCouponBasicDto数组 根据用户id
    public List<CandyUserCouponBasicDto> getCouponByUid(String uid, LocalDateTime userCreateTime) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        String publicRedisKey = CandyRedisConst.BASIC_COMMON_COUPON;

        Object obj = redisUtil.get(redisKey);
        Object obj2 = redisUtil.get(publicRedisKey);

        List<CandyUserCouponBasicDto> userDto;
        List<CandyCommonCouponBasicDto> pubDto;
        if (obj == null) {
            //降级
//            userDto = new ArrayList();
//            ResponseDto<Object> responseDto = feignPlatformCandyDemoteClient.queryForUserCouponBasicDto(uid);
//            if (responseDto.isSuccess()) {
//                userDto = (List<CandyUserCouponBasicDto>) responseDto.getData();
//            } else {
                userDto = ObjectUtil.getCandyUserCouponBasicDtoArrayList();
//            }
        } else {
            userDto = (List<CandyUserCouponBasicDto>) obj;
        }

        if (obj2 == null) {
            //降级
//            ResponseDto<Object> responseDto = feignPlatformCandyDemoteClient.queryForCommonCouponBasicDto(DateUtil.Formatter.yyyyMMddHHmmss.format(userCreateTime));
//            if (responseDto.isSuccess()) {
//                pubDto = (List<CandyCommonCouponBasicDto>) responseDto.getData();
//            } else {
                pubDto = ObjectUtil.getCandyCommonCouponBasicDtoArrayList();
//            }
        } else {
            pubDto = (List<CandyCommonCouponBasicDto>) obj2;
        }

        boolean needSet = false;
        if (userCreateTime == null) {
            userCreateTime = LocalDateTime.MIN;
        }
        List<String> userIds = userDto.stream().map(CandyUserCouponBasicDto::getCcouponId).collect(Collectors.toList());
        if (userIds!=null && userIds.size() > 0) {
            for (CandyCommonCouponBasicDto item : pubDto) {
                if (userIds.contains(item.getCcouponId()) || userCreateTime.isAfter(item.getCreatedAt())) {
                    continue;
                } else {
                    CandyUserCouponBasicDto userCouponBasicDto = CandyUserCouponBasicDto.getNew().copyToRedisCommonBaseCoupon(IDGenerator.get32UUID(), uid, item);
                    userDto.add(userCouponBasicDto);
                    needSet = true;
                }
            }
        }
        if (needSet) {
            setCouponByUid(uid, userDto);
        }
        return userDto;
    }

    // 覆盖 CandyUserCouponBasicDto数组 根据用户id
    public void setCouponByUid(String uid, List<CandyUserCouponBasicDto> dtoList) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        redisUtil.set(redisKey, dtoList);
    }

    // 添加 CandyUserCouponBasicDto数组  item
    public void addCouponByUid(String uid, CandyUserCouponBasicDto dto, LocalDateTime userCreateTime) {
        List<CandyUserCouponBasicDto> dtoList = getCouponByUid(uid, userCreateTime);
        dtoList.add(dto);
        setCouponByUid(uid, dtoList);
    }

    //获取 CandyCouponCodeDto 根据 ccode
    public CandyCouponCodeDto getCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponCodeDto) obj;
        }
    }

    //删除 CandyCouponCodeDto 根据 ccode
    public void delCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        redisUtil.del(redisKey);
    }

    //获取 CandyCouponInfoDto 根据 couponId
    public CandyCouponInfoDto getCouponInfo(String couponId) {
        String redisKey = CandyRedisConst.BASIC_COUPON_INFO.concat(couponId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponInfoDto) obj;
        }
    }
}
