package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinNftOrderGoodsSkuInfoVo", description = "NFT订单中商品SKU信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftOrderGoodsSkuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品详情展示文件URL[256]")
    private String skuWatch;
    @ApiModelProperty(position = 15, value = "展示文件类型[1-图片|2-视频|3-模型]")
    private String watchType;

    private static final GoblinNftOrderGoodsSkuInfoVo obj = new GoblinNftOrderGoodsSkuInfoVo();

    public static GoblinNftOrderGoodsSkuInfoVo getNew() {
        try {
            return (GoblinNftOrderGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderGoodsSkuInfoVo();
        }
    }

    public GoblinNftOrderGoodsSkuInfoVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuWatch(source.getSkuPic());
        this.setWatchType(source.getWatchType());
        return this;
    }
}
