package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeTicketStatisticalDao;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "KylinPerformanceSubscribeStatisticalVo", description = "预约统计")
@Data
public class KylinPerformanceSubscribeStatisticalVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "城市名称")
    private String cityName;
    @ApiModelProperty(value = "101音乐节 102小型演出(livehouse演出) 103巡演")
//    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演")
    private String type;
    @ApiModelProperty(value = "预约总人数")
    private Integer subscribeTotal;
    @ApiModelProperty(value = "详情页浏览人数")
    private Integer visitorNumber;
    @ApiModelProperty(value = "详情页浏览次数")
    private Integer visitorNumberCount;
    @ApiModelProperty(value = "票种浏览人数")
    private Integer visitorNumberTicket;
    @ApiModelProperty(value = "票种浏览次数")
    private Integer visitorNumberTicketCount;
    @ApiModelProperty(value = "票种详情")
    private List<KylinPerformanceSubscribeTicketStatisticalDao> kylinPerformanceSubscribeTicketStatisticalDaoList;
}
