package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.sweet.entity.SweetRemind;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.mapper.SweetRemindMapper;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 公众号模版消息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-27
 */
@Slf4j
@Service
public class SweetWechatTemplateServiceImpl {

    @Value("${liquidnet.wechat.service.zhengzai.appid}")
    private String appid;
    @Value("${liquidnet.wechat.service.zhengzai.secret}")
    private String secret;
    @Value("${liquidnet.client.admin.h5Url}")
    private String h5Url;

    @Value("${liquidnet.wechat.applet.zhengzai.appid}")
    private String appletAppid;

    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SweetRemindMapper sweetRemindMapper;

    public ResponseDto sendRemindMsg() {
        String templateId = "CNLDBZYQoDgTWudicx8WU81Jr9b6RyG9hmK4O0tpK-k";

        List<SweetRemind> sweetRemindList = sweetRemindMapper.selectList(
                Wrappers.lambdaQuery(SweetRemind.class)
                        .eq(SweetRemind::getIsPush, 1)
        );
        ArrayList<String> remindIdList = CollectionUtil.arrayListString();
        if (!CollectionUtils.isEmpty(sweetRemindList)) {
            for (SweetRemind remindInfo : sweetRemindList) {
                try {
                    String remindId = remindInfo.getRemindId();
                    SweetWechatUser sweetWechatUser = redisDataUtils.getSweetWechatUser(remindInfo.getUnionId());
                    KylinPerformanceVo performanceVo = (KylinPerformanceVo) redisUtil.get(KylinRedisConst.PERFORMANCES.concat(remindInfo.getPerformancesId()));
                    if (null == sweetWechatUser) {
                        remindIdList.add(remindId);
                        log.info("无用户数据：[UnionId=[{}]", remindInfo.getUnionId());
                        continue;
                    }
                    if (null == performanceVo) {
                        log.info("无演出数据：[getPerformancesId=[{}]", remindInfo.getPerformancesId());
                        continue;
                    }
                    KylinTicketTimesVo kylinTicketTimesVo = performanceVo.getTicketTimeList().get(0);

                    LocalDateTime nowTime = LocalDateTime.now();
                    String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(nowTime);
                    String sellTime = performanceVo.getSellTime();
                    LocalDateTime sellTimeLocal = LocalDateTime.parse(sellTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime sellTimeLocalNew = sellTimeLocal.minusMinutes(5);
                    String sellTimeLocalNewStr = DateUtil.Formatter.yyyyMMddHHmmss.format(sellTimeLocalNew);

                    String stopSellTime = performanceVo.getStopSellTime();
                    if (1 == DateUtil.compareStrDay(nowTimeStr, stopSellTime)) { // 超过售卖期 不推 删redis
                        log.info("超过售卖期：[nowTimeStr=[{}], [stopSellTime=[{}]",
                                nowTimeStr, stopSellTime);
                        remindIdList.add(remindId);
//                        redisDataUtils.delSweetRemind(remindInfo.getUnionId());
                        continue;
                    }
                    if (-1 == DateUtil.compareStrDay(nowTimeStr, sellTimeLocalNewStr)) { // 还没到售卖期
                        log.info("还没到售卖期：[nowTimeStr=[{}], [sellTimeLocalNewStr=[{}]",
                                nowTimeStr, sellTimeLocalNewStr);
                        continue;
                    }
                    // 发送模板消息接口
                    WxMpTemplateMessage templateMessage = getTemplateMessage(templateId, sweetWechatUser.getOpenId(), h5Url.concat("/#/ticket/detail?id=").concat(remindInfo.getPerformancesId()));
                    // 添加模板数据
                    templateMessage.addData(new WxMpTemplateData("first", "您关注的演出即将开始售票"))
                            .addData(new WxMpTemplateData("keyword1", performanceVo.getTitle()))
                            .addData(new WxMpTemplateData("keyword2", kylinTicketTimesVo.getTitle()))
                            .addData(new WxMpTemplateData("keyword3", performanceVo.getFieldName()))
                            .addData(new WxMpTemplateData("remark", "点击这里跳转购票"));
                    String msgId = sendTmpMsg(templateMessage);
                    if (null != msgId) {
                        remindIdList.add(remindId);
                    }
                } catch (Exception e) {
                    log.error("小程序演出提醒消息处理异常", e);
                }
            }
            if (!CollectionUtils.isEmpty(remindIdList)) {
                SweetRemind remindUpdate = SweetRemind.getNew();
                remindUpdate.setIsPush(2);
                remindUpdate.setUpdatedAt(LocalDateTime.now());
                sweetRemindMapper.update(
                        remindUpdate,
                        Wrappers.lambdaUpdate(SweetRemind.class)
                                .in(SweetRemind::getRemindId, remindIdList)
                );
            }
        }
        return ResponseDto.success();
    }

    public void subscribeSend(SweetWechatUser sweetWechatUser) {
        String templateId = "y-j82V1TYhlTH1j8QscuDPcPQtNiDtENb7N5IZMBvqU";
        try {
//            WxMpTemplateMessage templateMessage = getTemplateMessage(templateId, sweetWechatUser.getOpenId(), "");
            WxMpTemplateMessage templateMessage = getTemplateMessage(templateId, sweetWechatUser.getOpenId(), appletAppid, "pages/webview?query=active");
            // 添加模板数据
            templateMessage.addData(new WxMpTemplateData("first", "感谢关注「正在现场」服务号。我们是草莓音乐节演出官方票务平台。"))
                    .addData(new WxMpTemplateData("keyword1", "您已成功关注「正在现场」服务号"))
                    .addData(new WxMpTemplateData("keyword2", "4006-310-750"))
                    .addData(new WxMpTemplateData("remark", "随时查阅订单信息，第一时间获取演出开售提醒，更天天有福利，周周有惊喜！"));
            String msgId = sendTmpMsg(templateMessage);
        } catch (Exception e) {
            log.error("关注模版消息处理异常", e);
        }
    }

    /**
     * 获取templateMessage
     *
     * @param templateId
     * @param openId
     * @param url
     * @return
     */
    private WxMpTemplateMessage getTemplateMessage(String templateId, String openId, String url) {
        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                // 接收者openid
                .toUser(openId)
                // 模板id
                .templateId(templateId)
                // 模板跳转链接
                .url(url)
                .build();
        return templateMessage;
    }

    private WxMpTemplateMessage getTemplateMessage(String templateId, String openId, String appid, String pagePath) {
        //配置小程序信息
        WxMpTemplateMessage.MiniProgram miniProgram = new WxMpTemplateMessage.MiniProgram();
        miniProgram.setAppid(appid);//小程序appid
        miniProgram.setUsePath(true);
        miniProgram.setPagePath(pagePath);//用户点击时需要跳转的小程序页面

        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                // 接收者openid
                .toUser(openId)
                // 模板id
                .templateId(templateId)
                // 模板跳转链接
                .miniProgram(miniProgram)
                .build();
        return templateMessage;
    }

    /**
     * 发送消息
     *
     * @param templateMessage
     * @return
     */
    private String sendTmpMsg(WxMpTemplateMessage templateMessage) {
        String msgId = null;
        try {
            // 发送模板消息
            WxMpConfigStorage wxMpConfig = wxMpConfig(appid, secret);
            WxMpService wxMpService = wxMpService(wxMpConfig);
            msgId = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
            log.info("发送成功：[msgId=[{}]", msgId);
        } catch (WxErrorException e) {
            log.error("模版消息发送异常", e);
        }
        log.info("模版消息发送成功：[msgId=[{}]", msgId);
        return msgId;
    }

    private WxMpConfigStorage wxMpConfig(String appId, String appSecret) {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        config.setAppId(appId);
        config.setSecret(appSecret);
        return config;
    }

    private WxMpService wxMpService(WxMpConfigStorage mpConfig) {
        WxMpService service = new WxMpServiceImpl();
        service.setWxMpConfigStorage(mpConfig);
        return service;
    }

    public ResponseDto remind(String openId, String unionId, String performancesId) {
        redisDataUtils.setSweetRemind(openId, unionId, performancesId);
        return ResponseDto.success();
    }

    public boolean followStatus(String unionId) {
        SweetWechatUser sweetWechatUser = redisDataUtils.getSweetWechatUser(unionId);
        if (null != sweetWechatUser && !sweetWechatUser.getUnionId().isEmpty()) {
            return true;
        } else {
            return false;
        }
    }
}
