package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 轮播图
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@ApiModel(value = "GoblinFrontBannerBuildParam", description = "轮播图param")
@Data
public class GoblinFrontSelectGoodVo implements Serializable {
    /**
     * 数量
     */
    @ApiModelProperty( value = "精选商品数量")
    private int count;

    @ApiModelProperty( value = "商品列表")
    private List<GoblinGoodsInfoVo> goblinGoodsInfoVoList;


    private static final long serialVersionUID = 1L;

    private static final GoblinFrontSelectGoodVo obj = new GoblinFrontSelectGoodVo();

    public static GoblinFrontSelectGoodVo getNew() {
        try {
            return (GoblinFrontSelectGoodVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinFrontSelectGoodVo();
        }
    }

}
