package com.liquidnet.service.dragon.constant;

/**
 * 扫码错误码（暂时用不上、。）
 */
public enum DragonMicropayWepayCodeEnum {
    SYSTEMERROR("SYSTEMERROR","接口返回错误(系统超时)"),
    PARAM_ERROR("PARAM_ERROR","参数错误"),
    ORDERPAID("ORDERPAID","订单已支付(订单号重复)"),
    NOAUTH("NOAUTH","商户无权限"),
    AUTHCODEEXPIRE("AUTHCODEEXPIRE","二维码已过期，请用户在微信上刷新后再试"),
    NOTENOUGH("NOTENOUGH","余额不足"),
    NOTSUPORTCARD("NOTSUPORTCARD","不支持卡类型"),
    ORDERCLOSED("ORDERCLOSED","订单已关闭"),
    ORDERREVERSED("ORDERREVERSED","当前订单已经被撤销"),
    BANKERROR("BANKERROR","银行端超时"),
    USERPAYING("USERPAYING","用户支付中，需要输入密码"),
    AUTH_CODE_ERROR("AUTH_CODE_ERROR","付款码参数错误"),
    AUTH_CODE_INVALID("AUTH_CODE_INVALID","扫描的不是微信支付的条码"),
    XML_FORMAT_ERROR("XML_FORMAT_ERROR","XML格式错误"),
    REQUIRE_POST_METHOD("REQUIRE_POST_METHOD","请使用post方法"),
    SIGNERROR("SIGNERROR","参数签名结果不正确"),
    LACK_PARAMS("LACK_PARAMS","缺少必要的请求参数"),
    NOT_UTF8("NOT_UTF8","未使用指定编码格式"),
    BUYER_MISMATCH("BUYER_MISMATCH","支付账号错误"),
    APPID_NOT_EXIST("APPID_NOT_EXIST","参数中缺少APPID"),
    MCHID_NOT_EXIST("MCHID_NOT_EXIST","参数中缺少MCHID"),
    OUT_TRADE_NO_USED("OUT_TRADE_NO_USED","同一笔交易不能多次提交"),
    APPID_MCHID_NOT_MATCH("APPID_MCHID_NOT_MATCH","appid和mch_id不匹配"),
    INVALID_REQUEST("无效请求","商户系统异常导致，商户权限异常、重复请求支付、证书错误、频率限制等"),
    TRADE_ERROR("TRADE_ERROR","交易错误");

    private String code;
    private String message;
    DragonMicropayWepayCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
    public String getCode() {
        return code;
    }
    public static String getValue(String code) {
        DragonMicropayWepayCodeEnum[] carTypeEnums = values();
        for (DragonMicropayWepayCodeEnum carTypeEnum : carTypeEnums) {
            if (carTypeEnum.code.equals(code)) {
                return carTypeEnum.getMessage();
            }
        }
        return "未知错误";
    }
    public String getMessage() {
        return message;
    }
}
