package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserRegisterRespDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/10 20:46
 */
@ApiModel(value = "GalaxyUserRegisterRespDto", description = "用户实名注册")
@Data
public class GalaxyUserRegisterRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "用户区块链类型")
    private String blockChainType;

    @ApiModelProperty(position = 1, required = true, value = "用户区块链地址")
    private String blockChainAddress;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserRegisterRespDto obj = new GalaxyUserRegisterRespDto();

    public static GalaxyUserRegisterRespDto getNew() {
        try {
            return (GalaxyUserRegisterRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserRegisterRespDto();
        }
    }
}
