package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.cache.redisson.util.RedisLockUtil;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.feign.adam.api.FeignAdamBaseClient;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderScriptDto;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.middle.message.MessageConfigVo;
import com.liquidnet.service.kylin.dto.vo.middle.message.MessageDataVo;
import com.liquidnet.service.kylin.dto.vo.mongo.*;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderListVo;
import com.liquidnet.service.kylin.dto.vo.returns.OrderDetailsVo;
import com.liquidnet.service.kylin.dto.vo.returns.PayResultVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketEntitiesMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.kylin.service.IKylinOrderTicketsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.kylin.utils.*;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.AlibabaDamaiMevOpenBatchpushticketRequest;
import com.taobao.api.response.AlibabaDamaiMevOpenBatchpushticketResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.bson.Document;
import org.redisson.api.RLock;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class KylinOrderTicketsServiceImpl extends ServiceImpl<KylinOrderTicketsMapper, KylinOrderTickets> implements IKylinOrderTicketsService {

    @Value("${liquidnet.url-pay.pay}")
    private String payUrl;
    @Value("${liquidnet.url-pay.check}")
    private String checkUrl;
    @Value("${liquidnet.url-pay.localUrl}")
    private String synUrl;

    @Autowired
    private Environment environment;
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderUtils orderUtils;
    @Autowired
    private OtherUtils otherUtils;
    @Autowired
    private MongoVoUtils mongoVoUtils;
    @Autowired
    private RedisLockUtil redisLockUtil;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private FeignAdamBaseClient feignAdamBaseClient;
    @Autowired
    private TaobaoTicketUtils taobaoTicketUtils;
    @Autowired
    private KylinOrderTicketsMapper orderTicketsMapper;
    @Autowired
    private KylinOrderTicketEntitiesMapper entitiesMapper;

    @Override
    public ResponseDto<PayResultVo> checkCanOrder(PayOrderParam payOrderParam) {
        boolean isDownGeneral = false;
        String uid = CurrentUtil.getCurrentUid();
        if (!RedisLockUtil.tryLock("userId:" + uid, 2, 2)) {
            return ResponseDto.failure("请求频繁");//参数错误
        }
        RLock lock = RedisLockUtil.lock("userId:" + uid, 2);
        try {
            KylinPerformanceVo performanceData = dataUtils.getPerformanceVo(payOrderParam.getPerformanceId());
            KylinTicketTimesVo ticketTimesData = null;
            KylinTicketVo ticketData = null;
            for (int x = 0; x < performanceData.getTicketTimeList().size(); x++) {
                KylinTicketTimesVo timeItem = performanceData.getTicketTimeList().get(x);
                if (timeItem.getTimeId().equals(payOrderParam.getTimeId())) {
                    ticketTimesData = timeItem;
                    for (int y = 0; y < ticketTimesData.getTicketList().size(); y++) {
                        KylinTicketVo ticketItem = ticketTimesData.getTicketList().get(y);
                        if (ticketItem.getTicketsId().equals(payOrderParam.getTicketId())) {
                            ticketData = ticketItem;
                            break;
                        }
                    }
                    break;
                }
            }

            if (performanceData == null || ticketTimesData == null || ticketData == null) {
                lock.unlock();
                return ResponseDto.failure("参数错误");//参数错误
            }
            if (!ticketData.getTimeId().equals(payOrderParam.getTimeId()) || !ticketTimesData.getPerformanceId().equals(payOrderParam.getPerformanceId())) {
                lock.unlock();
                return ResponseDto.failure("参数错误");//参数错误List<AdamEntersVo> entersVoList
            }
            //判断代理
            if (!checkAgent(payOrderParam.getAgentId(), ticketData)) {
                lock.unlock();
                return ResponseDto.failure("无权购买");
            }

            Integer isStudent = ticketData.getIsStudent();
            //会员时间获取
            String memberTimeStart = ticketData.getMemberTimeStart(); // 会员开售时间
            String timeStart = ticketData.getTimeStart(); // 普通开售时间
            String timeEnd = ticketData.getTimeEnd(); // 购票停售时间
            String timeExpressEnd = ticketData.getTimeEndExpress(); // 快递停售时间
            boolean isMember = feignAdamBaseClient.isMember(uid).getData();//获取是否是会员
//            boolean isMember = true;
            int memberType; //会员状态 不需要判断会员 1判断会员逻辑 2会员专属
            if (ticketData.getIsExclusive() == 1) {
                memberType = 2;
                if (!isMember) {
                    lock.unlock();
                    return ResponseDto.failure("非会员用户暂不可购买");//没有会员权限
                }
            } else {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), memberTimeStart) == 1 && DateUtil.compareStrDay(DateUtil.getNowTime(), timeStart) == -1 && ticketData.getIsMember() == 1) {
                    // 会员购买逻辑
                    memberType = 1;
                    if (!isMember) {
                        lock.unlock();
                        return ResponseDto.failure("非会员用户暂不可购买");//没有会员权限
                    }
                } else {
                    // 普通用户购买逻辑
                    memberType = 0;
                }
            }

            // 获取限购 实名
            int ticketLimit = ticketData.getLimitCount();//普通票种限购
            int ticketMemberLimit = ticketData.getLimitCountMember();//会员票种限购
            int performanceLimit = performanceData.getLimitCount();//普通演出限购
            int performanceMemberLimit = performanceData.getLimitCountMember();//会员演出限购
            int isTrueName = ticketData.getIsTrueName();//是否演出实名

            //通用判断时间
            if (isMember) {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), memberTimeStart) == -1) {
                    lock.unlock();
                    return ResponseDto.failure("未开始售卖");//未开始
                }
            } else {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), timeStart) == -1) {
                    lock.unlock();
                    return ResponseDto.failure("未开始售卖");//未开始
                }
            }
            if (DateUtil.compareStrDay(DateUtil.getNowTime(), timeEnd) == 1) {
                lock.unlock();
                return ResponseDto.failure("售卖已结束");//已结束
            }

            //快递票判断
            if (payOrderParam.getIsExpress() != null) {
                if (payOrderParam.getIsExpress() == 1 && DateUtil.compareStrDay(DateUtil.getNowTime(), timeExpressEnd) == 1) {
                    lock.unlock();
                    return ResponseDto.failure("已超过快递票截止时间");//快递票不卖
                }
                if (payOrderParam.getIsExpress() == 1 && payOrderParam.getAddressId().isEmpty()) {
                    lock.unlock();
                    return ResponseDto.failure("快递票未填写收货地址");//快递票未填写收货地址
                }
            }
            //实名判断
            if (isTrueName == 1 && payOrderParam.getEnterIdList().size() <= 0) {
                lock.unlock();
                return ResponseDto.failure("入场人数量错误");//需要实名 未实名
            }
            if (isTrueName == 1 && payOrderParam.getEnterIdList().size() != payOrderParam.getNumber()) {
                lock.unlock();
                return ResponseDto.failure("入场人数量错误");//入场人数量错误
            }

            // 判断库存
            int surplusGeneral = dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), -payOrderParam.getNumber());
            if (surplusGeneral < 0) {//库存回滚
                dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                lock.unlock();
                return ResponseDto.failure("该票种已售罄");//没抢到
            } else {
                isDownGeneral = true;

                //学生票 判断
                List<AdamEntersVo> entersVoList = new ArrayList<>();
                if (isTrueName == 1) {
                    for (String enterId : payOrderParam.getEnterIdList()) {
                        AdamEntersVo adamEnters = feignAdamBaseClient.queryEnters(enterId, uid).getData();
                        entersVoList.add(adamEnters);
                        if (isStudent == 1) {
                            int age = IDCard.getAgeByIdCard(adamEnters.getIdCard());
                            if (age > 25) {
                                lock.unlock();
                                return ResponseDto.failure("年龄不符合");//年龄超了
                            }
                        }
                    }
                }

                //限购判断 如果实名 则身份证维度限购 如果不实名则数量限购
                Query queryPerformance = new Query();
                Query queryTicket = new Query();
                queryPerformance.addCriteria(Criteria.where("performanceId").is(payOrderParam.getPerformanceId()).and("status").in(KylinTableStatusConst.ORDER_STATUS0, KylinTableStatusConst.ORDER_STATUS1));
                queryTicket.addCriteria(Criteria.where("ticketId").is(payOrderParam.getTicketId()).and("status").in(KylinTableStatusConst.ORDER_STATUS0, KylinTableStatusConst.ORDER_STATUS1));


                if (entersVoList.size() > 0) {
                    for (int i = 0; i < entersVoList.size(); i++) {
                        String res1 = orderUtils.judgeOrderLimit(performanceData.getType(), uid, entersVoList.get(i).getIdCard(), payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), performanceLimit, performanceMemberLimit, ticketLimit, ticketMemberLimit, 1, 1, memberType, isTrueName);
                        if (!res1.equals("")) {
                            lock.unlock();
                            return ResponseDto.failure(res1);//乱七八糟异常
                        }
                    }
                } else {
                    String res1 = orderUtils.judgeOrderLimit(performanceData.getType(), uid, "", payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), performanceLimit, performanceMemberLimit, ticketLimit, ticketMemberLimit, payOrderParam.getNumber(), payOrderParam.getNumber(), memberType, isTrueName);
                    if (!res1.equals("")) {
                        lock.unlock();
                        return ResponseDto.failure(res1);//乱七八糟异常
                    }
                }
                lock.unlock();
                return order(payOrderParam, uid, isMember, isTrueName, performanceData, ticketData, entersVoList, isStudent, ticketTimesData);
            }
        } catch (Exception e) {
            if (isDownGeneral) {
                dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
            }
            e.printStackTrace();
            log.error("Kylin Order Pay Error = " + e.getMessage());
            lock.unlock();
            return ResponseDto.failure("下单失败");//乱七八糟异常
        }
    }

    private ResponseDto<PayResultVo> order(PayOrderParam payOrderParam, String uid, boolean isMember, int isTrueName, KylinPerformanceVo performanceData, KylinTicketVo ticketData, List<AdamEntersVo> entersVoList, Integer isStudent, KylinTicketTimesVo ticketTimesData) {
        LinkedList<String> sqls = new LinkedList<>();
        String source = CurrentUtil.getCliSource() == null ? "" : CurrentUtil.getCliSource();
        String version = CurrentUtil.getCliVersion() == null ? "" : CurrentUtil.getCliVersion();
        LocalDateTime now = LocalDateTime.now();
        //生成订单 order_ticket
        KylinOrderTickets orderTickets = new KylinOrderTickets();
        String orderTicketId = IDGenerator.nextSnowId().toString();
        orderTickets.setOrderTicketsId(orderTicketId);
        orderTickets.setUserId(uid);
        Map token = CurrentUtil.getTokenClaims();
        orderTickets.setUserName(StringUtils.defaultString(((String) token.get("nickname")), ""));
        orderTickets.setUserMobile(StringUtils.defaultString(((String) token.get("mobile")), ""));
//        orderTickets.setUserName("");
//        orderTickets.setUserMobile("");
        orderTickets.setPerformanceTitle(performanceData.getTitle());
        orderTickets.setOrderCode(IDGenerator.ticketOrderCode(orderTicketId));
        orderTickets.setPayCode("");
        orderTickets.setQrCode("");
        orderTickets.setOrderType(source);
        orderTickets.setOrderVersion(version);
        orderTickets.setNumber(payOrderParam.getNumber());
        orderTickets.setPrice(ticketData.getPrice());
        orderTickets.setPriceMember(ticketData.getMemberPrice());
        if (isMember) {
            orderTickets.setPriceTotal(ticketData.getMemberPrice().multiply(new BigDecimal(payOrderParam.getNumber())).add(payOrderParam.getIsExpress() == 1 ? ticketData.getPriceExpress() : new BigDecimal("0")));
        } else {
            orderTickets.setPriceTotal(ticketData.getPrice().multiply(new BigDecimal(payOrderParam.getNumber())).add(payOrderParam.getIsExpress() == 1 ? ticketData.getPriceExpress() : new BigDecimal("0")));
        }

        if (Arrays.asList("dev", "test").contains(environment.getProperty("spring.profiles.active"))) {
            orderTickets.setPriceActual(new BigDecimal("0.01"));
        } else {
            orderTickets.setPriceActual(orderTickets.getPriceTotal());
        }

        orderTickets.setPriceVoucher(new BigDecimal("0.0"));
        orderTickets.setPriceExpress(ticketData.getPriceExpress());
        orderTickets.setPriceRefund(new BigDecimal(0.0));
        orderTickets.setRefundNumber(0);
        orderTickets.setPayType(payOrderParam.getPayType());
        orderTickets.setPaymentType(null);
        orderTickets.setTimePay(null);
        if (payOrderParam.getIsExpress() == 1) {
            AdamAddressesVo addressesVo = feignAdamBaseClient.queryAddresses(payOrderParam.getAddressId(), uid).getData();
            orderTickets.setExpressContacts(addressesVo.getName());
            orderTickets.setExpressAddress(addressesVo.getAddress());
            orderTickets.setExpressPhone(addressesVo.getPhone());
            orderTickets.setGetTicketType("express");
        } else {
            orderTickets.setExpressContacts("");
            orderTickets.setExpressAddress("");
            orderTickets.setExpressPhone("");
            orderTickets.setGetTicketType("electronic");
        }
        orderTickets.setCouponType("no");
        orderTickets.setGetTicketDescribe("");
        orderTickets.setPayCountdownMinute(performanceData.getPayCountdownMinute());
        orderTickets.setCreatedAt(now);
        orderTickets.setUpdatedAt(null);


        //生成订单 order_ticket_status
        KylinOrderTicketStatus orderTicketStatus = new KylinOrderTicketStatus();
        String orderTicketStatusId = IDGenerator.nextSnowId().toString();
        orderTicketStatus.setOrderTicketStatusId(orderTicketStatusId);
        orderTicketStatus.setOrderId(orderTicketId);
        orderTicketStatus.setExpressType(payOrderParam.getExpressType());
        orderTicketStatus.setTransferStatus(KylinTableStatusConst.ORDER_TRANSFER_STATUS0);
        orderTicketStatus.setStatus(KylinTableStatusConst.ORDER_STATUS0);
        orderTicketStatus.setIsStudent(isStudent);
        orderTicketStatus.setPayStatus(KylinTableStatusConst.ORDER_PAY_STATUS0);
        orderTicketStatus.setCreatedAt(now);
        orderTicketStatus.setUpdatedAt(null);
        sqls.add(SqlMapping.get("kylin_order_ticket_status.add"));
        LinkedList<Object[]> sqlsDataB = new LinkedList<Object[]>();
        sqlsDataB.add(orderTicketStatus.getAddObject());

        //生成订单 order_ticket_relation
        KylinOrderTicketRelations orderTicketRelations = new KylinOrderTicketRelations();
        String orderTicketRelationId = IDGenerator.nextSnowId().toString();
        orderTicketRelations.setOrderTicketRelationsId(orderTicketRelationId);
        orderTicketRelations.setOrderId(orderTicketId);
        orderTicketRelations.setTransferId("");
        orderTicketRelations.setLiveId("");
        orderTicketRelations.setAgentId(payOrderParam.getAgentId());
        orderTicketRelations.setIsMember(isMember ? 1 : 0);
        orderTicketRelations.setPerformanceId(payOrderParam.getPerformanceId());
        orderTicketRelations.setTimeId(payOrderParam.getTimeId());
        orderTicketRelations.setTicketId(payOrderParam.getTicketId());
        orderTicketRelations.setCreatedAt(now);
        orderTicketRelations.setUpdatedAt(null);
        sqls.add(SqlMapping.get("kylin_order_ticket_relation.add"));
        LinkedList<Object[]> sqlsDataC = new LinkedList<Object[]>();
        sqlsDataC.add(orderTicketRelations.getAddObject());


        //生成票
        KylinOrderTicketEntities orderTicketEntities = new KylinOrderTicketEntities();
        String orderTicketEntitiesId = IDGenerator.nextSnowId().toString();
        LinkedList<Object[]> sqlsDataD = null;
        sqlsDataD = new LinkedList<Object[]>();
        if (isTrueName == 1) {
            for (AdamEntersVo enters : entersVoList) {
                orderTicketEntities.setOrderTicketEntitiesId(orderTicketEntitiesId);
                orderTicketEntities.setOrderId(orderTicketId);
                orderTicketEntities.setTicketId(payOrderParam.getTicketId());
                orderTicketEntities.setUserId(uid);
                orderTicketEntities.setPerformanceId(payOrderParam.getPerformanceId());
                orderTicketEntities.setTimeId(payOrderParam.getTimeId());
                orderTicketEntities.setEnterType(enters.getType());
                orderTicketEntities.setEnterName(enters.getName());
                orderTicketEntities.setEnterMobile(enters.getMobile());
                orderTicketEntities.setEnterIdCode(enters.getIdCard());
                orderTicketEntities.setStatus(KylinTableStatusConst.ENTITIES_STATUS0);
                orderTicketEntities.setSysDamai(ticketData.getSysDamai());
                orderTicketEntities.setCheckClient("");
                orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT0);
                orderTicketEntities.setComment("");
                orderTicketEntities.setCreatedAt(now);
                orderTicketEntities.setUpdatedAt(null);
                sqls.add(SqlMapping.get("kylin_order_ticket_entities.add"));
                sqlsDataD.add(orderTicketEntities.getAddObject());
                // 生成vo
                KylinOrderTicketEntitiesVo orderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
                BeanUtils.copyProperties(orderTicketEntities, orderTicketEntitiesVo);
                orderTicketEntitiesVo.setPerformanceTitle(performanceData.getTitle());
                orderTicketEntitiesVo.setTicketTitle(ticketData.getTitle());
                orderTicketEntitiesVo.setUseStart(ticketData.getUseStart());
                orderTicketEntitiesVo.setUseEnd(ticketData.getUseEnd());
                orderTicketEntitiesVo.setTicketsmId(ticketData.getMid());
                orderTicketEntitiesVo.setTimemId(ticketTimesData.getMid());
                orderTicketEntitiesVo.setCreatedAt(orderTicketEntities.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                orderTicketEntitiesVo.setUpdatedAt(null);
                orderTicketEntitiesVo.setChangeDate(orderTicketEntities.getCreatedAt());
                mongoTemplate.insert(orderTicketEntitiesVo, KylinOrderTicketEntitiesVo.class.getSimpleName());
                dataUtils.changeBuyInfo(orderTicketEntitiesVo.getUserId(), orderTicketEntitiesVo.getEnterIdCode(), orderTicketEntitiesVo.getPerformanceId(), orderTicketEntitiesVo.getTicketId(), 1);
            }
        } else {
            for (int i = 0; i < payOrderParam.getNumber(); i++) {
                orderTicketEntities.setOrderTicketEntitiesId(orderTicketEntitiesId);
                orderTicketEntities.setOrderId(orderTicketId);
                orderTicketEntities.setTicketId(payOrderParam.getTicketId());
                orderTicketEntities.setUserId(uid);
                orderTicketEntities.setPerformanceId(payOrderParam.getPerformanceId());
                orderTicketEntities.setTimeId(payOrderParam.getTimeId());
                orderTicketEntities.setEnterType(0);
                orderTicketEntities.setEnterName("");
                orderTicketEntities.setEnterMobile("");
                orderTicketEntities.setEnterIdCode("");
                orderTicketEntities.setStatus(KylinTableStatusConst.ENTITIES_STATUS0);
                orderTicketEntities.setSysDamai(ticketData.getSysDamai());
                orderTicketEntities.setCheckClient("");
                orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT0);
                orderTicketEntities.setComment("");
                orderTicketEntities.setCreatedAt(now);
                orderTicketEntities.setUpdatedAt(null);
                sqls.add(SqlMapping.get("kylin_order_ticket_entities.add"));
                sqlsDataD.add(orderTicketEntities.getAddObject());
                // 生成vo
                KylinOrderTicketEntitiesVo orderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
                BeanUtils.copyProperties(orderTicketEntities, orderTicketEntitiesVo);
                orderTicketEntitiesVo.setPerformanceTitle(performanceData.getTitle());
                orderTicketEntitiesVo.setTicketTitle(ticketData.getTitle());
                orderTicketEntitiesVo.setUseStart(ticketData.getUseStart());
                orderTicketEntitiesVo.setUseEnd(ticketData.getUseEnd());
                orderTicketEntitiesVo.setTicketsmId(ticketData.getMid());
                orderTicketEntitiesVo.setTimemId(ticketTimesData.getMid());
                orderTicketEntitiesVo.setCreatedAt(orderTicketEntities.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                orderTicketEntitiesVo.setUpdatedAt(null);
                orderTicketEntitiesVo.setChangeDate(orderTicketEntities.getCreatedAt());
                mongoTemplate.insert(orderTicketEntitiesVo, KylinOrderTicketEntitiesVo.class.getSimpleName());
                dataUtils.changeBuyInfo(orderTicketEntitiesVo.getUserId(), orderTicketEntitiesVo.getEnterIdCode(), orderTicketEntitiesVo.getPerformanceId(), orderTicketEntitiesVo.getTicketId(), 1);
            }
        }
        // 调用支付
        String time1 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseStart()), DateUtil.Formatter.MM_dd_zh);
        String time2 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseEnd()), DateUtil.Formatter.MM_dd_zh);
        String useTime = ticketData.getType() == 2 ? time1 + "~" + time2 : time2;


        LinkedMultiValueMap<String, String> httpData = new LinkedMultiValueMap<String, String>();
        httpData.add("type", "TICKET");
        if (Arrays.asList("dev", "test").contains(environment.getProperty("spring.profiles.active"))) {
            httpData.add("price", "0.01");
        } else {
            httpData.add("price", orderTickets.getPriceActual().toString());
        }
        httpData.add("name", useTime + ticketData.getTitle() + "-" + performanceData.getTitle());
        httpData.add("detail", performanceData.getTitle() + "-" + ticketData.getTitle() + "-" + useTime);
        httpData.add("order_code", orderTickets.getOrderCode());
        httpData.add("client_ip", CurrentUtil.getCliIpAddr());
        httpData.add("notify_url", synUrl);
        httpData.add("create_date", orderTickets.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        httpData.add("expire_time", orderTickets.getPayCountdownMinute().toString());

        if (payOrderParam.getDeviceFrom().equals("js") || payOrderParam.getDeviceFrom().equals("applet")) {
            httpData.add("open_id", payOrderParam.getOpenId());
        }
        if (payOrderParam.getPayType().equals("alipay") && payOrderParam.getDeviceFrom().equals("wap")) {
            httpData.add("show_url", payOrderParam.getShowUrl() + orderTicketId);
            httpData.add("return_url", payOrderParam.getReturnUrl() + orderTicketId);
        }

        String returnData = HttpUtil.post(payUrl + payOrderParam.getDeviceFrom() + "/" + payOrderParam.getPayType(), httpData);
        PayResultVo payResultVo = JsonUtils.fromJson(returnData, PayResultVo.class);
        payResultVo.setOrder_id(orderTicketId);
        payResultVo.setPrice(orderTickets.getPriceActual());
        orderTickets.setPayCode(payResultVo.getCode());
        sqls.add(SqlMapping.get("kylin_order_ticket.add"));
        LinkedList<Object[]> sqlsDataA = new LinkedList<>();
        sqlsDataA.add(orderTickets.getAddObject());

        if (payOrderParam.getPayType().equals("alipay") && payOrderParam.getDeviceFrom().equals("wap")) {
            payResultVo.setShowUrl(payOrderParam.getShowUrl() + orderTicketId);
            payResultVo.setReturnUrl(payOrderParam.getReturnUrl() + orderTicketId);
        }
        // 生成vo
        KylinOrderTicketVo orderTicketVo = new KylinOrderTicketVo();
        orderTicketVo.setOrderTicket(orderTickets);
        orderTicketVo.setOrderTicketStatus(orderTicketStatus);
        orderTicketVo.setOrderTicketRelation(orderTicketRelations);
        orderTicketVo.setPerformanceImg(performanceData.getImgPoster());
        orderTicketVo.setTicketTitle(ticketData.getTitle());
        orderTicketVo.setUseStart(ticketData.getUseStart());
        orderTicketVo.setTimeStart(performanceData.getTimeStart());
        orderTicketVo.setOverdueAt(orderTickets.getCreatedAt().plusMinutes(performanceData.getPayCountdownMinute()).plusSeconds(15).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setCreatedAt(orderTickets.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setChangeDate(orderTickets.getCreatedAt());
        mongoTemplate.insert(orderTicketVo, KylinOrderTicketVo.class.getSimpleName());

        mongoVoUtils.resetOrderListVo(uid, 1, orderTicketVo.getOrderTicketsId());

        // 执行sql
        String sqlData = SqlMapping.gets(sqls, sqlsDataB, sqlsDataC, sqlsDataD, sqlsDataA);
        rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE, MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
                sqlData);
        return ResponseDto.success(payResultVo);
    }

    @Override
    public ResponseDto<PayResultVo> payAgain(PayAgainParam payAgainParam) {
        try {
            String uid = CurrentUtil.getCurrentUid();
            checkOrderTime(uid);
            //检查订单时间 是否关闭
            KylinOrderTicketVo orderTicketData = dataUtils.getOrderTicketVo(payAgainParam.getOrderId());
            if (orderTicketData == null) {
                return ResponseDto.failure("订单不存在");
            }

            if (orderTicketData.getStatus() == KylinTableStatusConst.ORDER_STATUS1) {
                return ResponseDto.failure("订单已支付");
            } else {
                if (orderTicketData.getStatus() != KylinTableStatusConst.ORDER_STATUS0) {
                    return ResponseDto.failure("订单已关闭");
                }
            }
            String returnCheckData = HttpUtil.get(checkUrl + "?code=" + orderTicketData.getPayCode(), null);
            PayResultVo checkVo = JsonUtils.fromJson(returnCheckData, PayResultVo.class);
            if (checkVo.getStatus() == 1) {
                return ResponseDto.failure("'您已支付请刷新再试'");
            }
            if (!orderTicketData.getPayType().equals("no")) {

                if (orderTicketData.getEntitiesVoList().size() == 0) {
                    return ResponseDto.failure("参数错误");
                }
                KylinOrderTicketEntitiesVo entitiesData = orderTicketData.getEntitiesVoList().get(0);

                LinkedMultiValueMap<String, String> httpData = new LinkedMultiValueMap<String, String>();
                httpData.add("type", "TICKET");
                if (Arrays.asList("dev", "test").contains(environment.getProperty("spring.profiles.active"))) {
                    httpData.add("price", orderTicketData.getPriceActual().toString());
                } else {
                    httpData.add("price", "0.01");
                }
                httpData.add("name", entitiesData.getUseStart() + "" + entitiesData.getPerformanceTitle());
                httpData.add("detail", entitiesData.getPerformanceTitle() + "-" + entitiesData.getTicketTitle() + "-" + entitiesData.getUseStart());
                httpData.add("order_code", orderTicketData.getOrderCode());
                httpData.add("client_ip", CurrentUtil.getCliIpAddr());
                httpData.add("notify_url", synUrl);
                httpData.add("create_date", orderTicketData.getCreatedAt());
                httpData.add("expire_time", orderTicketData.getPayCountdownMinute().toString());

                httpData.add("open_id", payAgainParam.getOpenId());

                if (payAgainParam.getPayType().equals("alipay") && payAgainParam.getDeviceFrom().equals("wap")) {
                    httpData.add("show_url", payAgainParam.getShowUrl());
                    httpData.add("return_url", payAgainParam.getReturnUrl());
                }

                String returnData = HttpUtil.post(payUrl + payAgainParam.getDeviceFrom() + "/" + payAgainParam.getPayType(), httpData);
                PayResultVo payResultVo = JsonUtils.fromJson(returnData, PayResultVo.class);
                payResultVo.setOrder_id(orderTicketData.getOrderTicketsId());
                payResultVo.setPrice(orderTicketData.getPriceActual());
                if (payAgainParam.getPayType().equals("alipay") && payAgainParam.getDeviceFrom().equals("wap")) {
                    payResultVo.setShowUrl(payAgainParam.getShowUrl());
                    payResultVo.setReturnUrl(payAgainParam.getReturnUrl());
                }

                KylinOrderTickets orderTickets = new KylinOrderTickets();
                orderTickets.setOrderTicketsId(payAgainParam.getOrderId());
                orderTickets.setUpdatedAt(LocalDateTime.now());
                orderTickets.setPayCode(payResultVo.getCode());
                orderTickets.setPayType(payAgainParam.getPayType());

                //改vo
                HashMap<String, Object> map = new HashMap<>();
                map.put("payType", payAgainParam.getPayType());
                map.put("payCode", payResultVo.getCode());
                map.put("updatedAt", DateUtil.Formatter.yyyyMMddHHmmss.format(orderTickets.getUpdatedAt()));
                map.put("changeDate", orderTickets.getUpdatedAt());
                Document doc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                        Query.query(Criteria.where("orderTicketsId").is(payAgainParam.getOrderId())).getQueryObject(),
                        new BasicDBObject("$set", mongoConverter.convertToMongoType(map)),
                        new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE)
                );

                KylinOrderTicketVo orderTicketVo = BsonUtil.toBean(doc, KylinOrderTicketVo.class);
                LocalDateTime strTime = orderTicketVo.getChangeDate();
                dataUtils.delOrderTicketRedis(orderTickets.getOrderTicketsId());

                LinkedList<String> sqls = new LinkedList<>();
                sqls.add(SqlMapping.get("kylin_order_ticket.payAgain"));
                LinkedList<Object[]> sqlsDataA = new LinkedList<>();
                sqlsDataA.add(orderTickets.getPayAgainObject(strTime, strTime));
                sqls.add(SqlMapping.get("kylin_order_ticket_status.payAgain"));
                LinkedList<Object[]> sqlsDataB = new LinkedList<>();
                sqlsDataB.add(new Object[]{orderTickets.getUpdatedAt(),orderTickets.getOrderTicketsId(),strTime, strTime});
                sqls.add(SqlMapping.get("kylin_order_ticket_relation.payAgain"));
                LinkedList<Object[]> sqlsDataC = new LinkedList<>();
                sqlsDataC.add(new Object[]{orderTickets.getUpdatedAt(),orderTickets.getOrderTicketsId(),strTime, strTime});

                String sqlData = SqlMapping.gets(sqls, sqlsDataA,sqlsDataB, sqlsDataC);
                rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_AGAIN, MQConst.ROUTING_KEY_SQL_ORDER_AGAIN,sqlData);
                return ResponseDto.success(payResultVo);
            }
            return ResponseDto.failure("未选择支付方式");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure("订单已失效");
        }

    }

    @Override
    public String syncOrder(SyncOrderParam syncOrderParam) {
        //支付时间
        LocalDateTime now = LocalDateTime.now();
//
//        if (!RedisLockUtil.tryLock("order_lock:" + syncOrderParam.getOrder_code(), 240, 240)) {
//            return "fail";//参数错误
//        }
//        RLock lock = RedisLockUtil.lock("order_lock:" + syncOrderParam.getOrder_code(), 240);


        String timePay = DateUtil.Formatter.yyyyMMddHHmmss.format(now);
        KylinOrderTicketVo orderTicketData = mongoTemplate.findOne(Query.query(Criteria.where("orderCode").is(syncOrderParam.getOrder_code())), KylinOrderTicketVo.class, KylinOrderTicketVo.class.getSimpleName());
        if (orderTicketData == null) {
//            lock.unlock();
            return "fail";//订单不存在
        }

        if (orderTicketData.getStatus() != KylinTableStatusConst.ORDER_STATUS0) {
            if (orderTicketData.getPayCode().equals(syncOrderParam.getCode()) && orderTicketData.getStatus() == KylinTableStatusConst.ORDER_STATUS1) {
//                lock.unlock();
                return "success";//已经支付
            }

            if (!orderTicketData.getPayCode().equals(syncOrderParam.getCode())) {
//                lock.unlock();
                return "fail";//重复支付
            }
        }

        if (orderTicketData.getPriceActual().compareTo(syncOrderParam.getPrice()) != 0) {
//            lock.unlock();
            return "fail";//价格不符
        }

        LinkedList<String> sqls = new LinkedList<>();
        LocalDateTime strTime = orderTicketData.getChangeDate();

        //sql
        KylinOrderTickets orderTickets = new KylinOrderTickets();
        orderTickets.setOrderTicketsId(orderTicketData.getOrderTicketsId());
        orderTickets.setPaymentType(syncOrderParam.getPayment_type());
        orderTickets.setPayCode(syncOrderParam.getCode());
        orderTickets.setTimePay(timePay);
        orderTickets.setQrCode(IDGenerator.ticketQrCode(orderTicketData.getOrderTicketsId()));
        orderTickets.setUpdatedAt(now);
        sqls.add(SqlMapping.get("kylin_order_ticket.synPay"));
        LinkedList<Object[]> sqlsDataA = new LinkedList<>();
        sqlsDataA.add(orderTickets.getSynOrderObject(strTime, strTime));

        KylinOrderTicketStatus orderTicketStatus = new KylinOrderTicketStatus();
        orderTicketStatus.setOrderId(orderTicketData.getOrderTicketsId());
        orderTicketStatus.setStatus(KylinTableStatusConst.ORDER_STATUS1);
        orderTicketStatus.setPayStatus(syncOrderParam.getStatus());
        orderTicketStatus.setUpdatedAt(orderTickets.getUpdatedAt());
        sqls.add(SqlMapping.get("kylin_order_ticket_status.synPay"));
        LinkedList<Object[]> sqlsDataB = new LinkedList<>();
        sqlsDataB.add(orderTicketStatus.getSynOrderObject(strTime, strTime));

        sqls.add(SqlMapping.get("kylin_order_ticket_relation.synPay"));
        LinkedList<Object[]> sqlsDataC = new LinkedList<>();
        sqlsDataC.add(new Object[]{orderTickets.getUpdatedAt(),orderTickets.getOrderTicketsId(),strTime, strTime});

        KylinOrderTicketEntities orderTicketEntities = new KylinOrderTicketEntities();
        orderTicketEntities.setOrderId(orderTicketData.getOrderTicketsId());
        orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT1);
        orderTicketEntities.setUpdatedAt(orderTickets.getUpdatedAt());
        sqls.add(SqlMapping.get("kylin_order_ticket_entities.synPay"));
        LinkedList<Object[]> sqlsDataD = new LinkedList<>();
        sqlsDataD.add(orderTicketEntities.getSynOrderObject(strTime, strTime));


        //vo
        HashMap<String, Object> orderTicketVo = new HashMap<>();
        orderTicketVo.put("paymentType", orderTickets.getPaymentType());
        orderTicketVo.put("payCode", orderTickets.getPayCode());
        orderTicketVo.put("timePay", orderTickets.getTimePay());
        orderTicketVo.put("qrCode", orderTickets.getQrCode());
        orderTicketVo.put("status", KylinTableStatusConst.ORDER_STATUS1);
        orderTicketVo.put("payStatus", orderTicketStatus.getStatus());
        orderTicketVo.put("updatedAt", timePay);
        orderTicketVo.put("changeDate", now);
        mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTickets.getOrderTicketsId())).getQueryObject(),
                new BasicDBObject("$set", mongoConverter.convertToMongoType(orderTicketVo))
        );


        HashMap<String, Object> orderTicketEntitiesVo = new HashMap<>();
        orderTicketEntitiesVo.put("isPayment", KylinTableStatusConst.ENTITIES_IS_PAYMENT1);
        orderTicketEntitiesVo.put("updatedAt", timePay);
        orderTicketEntitiesVo.put("changeDate", now);
        mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateMany(
                Query.query(Criteria.where("orderId").is(orderTickets.getOrderTicketsId())).getQueryObject(),
                new BasicDBObject("$set", mongoConverter.convertToMongoType(orderTicketEntitiesVo))
        );
        dataUtils.delOrderTicketRedis(orderTickets.getOrderTicketsId());

        rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY, MQConst.ROUTING_KEY_SQL_ORDER_PAY,
                SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC,sqlsDataD));

        //生成vo redis
        mongoVoUtils.resetOrderListVo(orderTicketData.getUserId(), 2, orderTicketData.getOrderTicketsId());
        // 发短信
        KylinPerformanceVo performanceData = dataUtils.getPerformanceVo(orderTicketData.getPerformanceId());
        KylinTicketTimesVo ticketTimesData = null;
        KylinTicketVo ticketData = null;
        for (int x = 0; x < performanceData.getTicketTimeList().size(); x++) {
            KylinTicketTimesVo timeItem = performanceData.getTicketTimeList().get(x);
            if (timeItem.getTimeId().equals(orderTicketData.getTimeId())) {
                ticketTimesData = timeItem;
                for (int y = 0; y < ticketTimesData.getTicketList().size(); y++) {
                    KylinTicketVo ticketItem = ticketTimesData.getTicketList().get(y);
                    if (ticketItem.getTicketsId().equals(orderTicketData.getTicketId())) {
                        ticketData = ticketItem;
                        break;
                    }
                }
                break;
            }
        }

        MessageDataVo dataVo = new MessageDataVo();
        dataVo.setName(orderTicketData.getPerformanceTitle());
        String time1 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseStart()), DateUtil.Formatter.yyyy_MM_dd);
        String time2 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceData.getTimeStart()), DateUtil.Formatter.HHmm);
        dataVo.setTime(time1 + " " + time2);

        MessageConfigVo configVo = new MessageConfigVo();
        configVo.setStatus(true);
        if (orderTicketData.getGetTicketType().equals("express")) {
            configVo.setId("SMS_181490473");
        } else if (orderTicketData.getGetTicketType().equals("electronic")) {
            configVo.setId(ticketData.getIsShowCode() == 1 ? "SMS_171358560" : "SMS_181500419");
        }
        otherUtils.sendMessage(orderTicketData.getUserMobile(), dataVo, configVo, 1);

        // 大麦回调
        sycDamaiOrder(orderTickets.getOrderTicketsId());
        return "success";
    }

    @Override
    public PageInfo<List<KylinOrderListVo>> orderList(int page, int size) {
        //TODO 缺快递
        PageInfo<List<KylinOrderListVo>> mPageInfo = null;
        String uid = CurrentUtil.getCurrentUid();
        checkOrderTime(uid);
        try {
            List<KylinOrderListVo> voList = dataUtils.getOrderList(uid);
            for (int i = 0; i < voList.size(); i++) {
                KylinOrderListVo item = voList.get(i);
                //TODO 顺丰快递
                Object expresses = null;
                if (null != expresses) {
                    item.setExpress_number("");//expresses.getNumber()
                    item.setExpress_company("");//expresses.getName()
                    item.setKuaidi_status(-2);//expresses.getStatus()
                } else {
                    item.setExpress_number("");
                    item.setExpress_company("");
                    item.setKuaidi_status(-2);
                }

                if (item.getStatus() == KylinTableStatusConst.ORDER_STATUS0) {
                    item.setRestTime(DateUtil.intervalSeconds(
                            DateUtil.parse(item.getOverdueAt(), "yyyy-MM-dd HH:mm:ss"),
                            DateUtil.parse(DateUtil.getNowTime(), "yyyy-MM-dd HH:mm:ss")
                    ));
                } else {
                    item.setRestTime(0L);
                }
                if (voList.size() >= 40) {
                    break;
                }
            }

            mPageInfo = new PageInfo(voList);
            mPageInfo.setTotal(voList.size());
            return mPageInfo;
        } catch (Exception e) {
            e.printStackTrace();
            return mPageInfo;
        }
    }

    @Override
    public OrderDetailsVo orderDetails(String orderId) {
        OrderDetailsVo vo = new OrderDetailsVo();
        try {
            String uid = CurrentUtil.getCurrentUid();
            checkOrderTime(uid);
            KylinOrderTicketVo orderTicketVo = dataUtils.getOrderTicketVo(orderId);
            if (null != orderTicketVo) {
                //TODO 顺丰快递
                Object expresses = null;
//                Expresses expresses = expressesMapper.selectOne(new UpdateWrapper<Expresses>().eq("order_id", orderId).eq("order_type", "order_ticket"));
                KylinPerformanceVo performanceVo = dataUtils.getPerformanceVo(orderTicketVo.getPerformanceId());
                List<KylinOrderTicketEntitiesVo> kylinOrderTicketEntitiesVoList = orderTicketVo.getEntitiesVoList();
                KylinTicketVo ticketVo = null;

                //获取购票数据
                for (int x = 0; x < performanceVo.getTicketTimeList().size(); x++) {
                    KylinTicketTimesVo timeItem = performanceVo.getTicketTimeList().get(x);
                    for (int y = 0; y < timeItem.getTicketList().size(); y++) {
                        KylinTicketVo ticketItem = timeItem.getTicketList().get(y);
                        if (ticketItem.getTicketsId().equals(orderTicketVo.getTicketId())) {
                            ticketVo = ticketItem;
                            break;
                        }
                    }
                }

                orderTicketVo.setIsTrueName(ticketVo.getIsTrueName());
                orderTicketVo.setNoticeImage(performanceVo.getNoticeImage());
                orderTicketVo.setTicketType(ticketVo.getType());
                orderTicketVo.setFieldName(performanceVo.getFieldName());
                if (ticketVo.getIsShowCode() == 1) {
                    Date date = DateUtil.parse(ticketVo.getQrCodeShowTime(), DateUtil.Formatter.yyyyMMddHHmm.toString());
                    if (DateUtil.compareDay(date, DateUtil.now()) > 0) {
                        orderTicketVo.setQrCode("");
                    }
                } else {
                    orderTicketVo.setQrCode("");
                }


                // 数据脱敏
                for (KylinOrderTicketEntitiesVo item : kylinOrderTicketEntitiesVoList) {
                    if (item.getEnterIdCode().length() == 18) {
                        item.setEnterIdCode(item.getEnterIdCode().substring(0, 3) + "*************" + item.getEnterIdCode().substring(16));
                    }
                    if (item.getEnterMobile().length() == 11) {
                        item.setEnterMobile(item.getEnterMobile().substring(0, 3) + "****" + item.getEnterMobile().substring(7));
                    }
                }
                //计算 倒计时
                if (orderTicketVo.getStatus() == KylinTableStatusConst.ORDER_STATUS0) {
                    vo.setRestTime(DateUtil.intervalSeconds(
                            DateUtil.parse(orderTicketVo.getOverdueAt(), "yyyy-MM-dd HH:mm:ss"),
                            DateUtil.parse(DateUtil.getNowTime(), "yyyy-MM-dd HH:mm:ss")
                    ));
                } else {
                    vo.setRestTime(0L);
                }
                //快递
                if (null != expresses) {
                    vo.setExpress_number("");//expresses.getNumber()
                    vo.setExpress_company("");//expresses.getName()
                    vo.setKuaidi_status(-2);//expresses.getStatus()
                } else {
                    vo.setExpress_number("");
                    vo.setExpress_company("");
                    vo.setKuaidi_status(-2);
                }
                vo.setOrderTicketVo(orderTicketVo);
            }
            return vo;
        } catch (Exception e) {
            return vo;
        }
    }

    @Override
    public boolean checkOrderTime(String userId) {
        List<OrderScriptDto> dtoData = orderTicketsMapper.orderScriptDto(userId);
        LinkedList<String> sqls = new LinkedList<>();

        for (OrderScriptDto item : dtoData) {
//            if (!RedisLockUtil.tryLock("order_lock:" + item.getOrderCode(), 30, 240)) {
//                continue;
//            }
//            RLock lock = redisLockUtil.lock("order_lock:" + item.getOrderCode(), 240);
            if (item.getStatus() == KylinTableStatusConst.ORDER_STATUS0) {
                LocalDateTime now = LocalDateTime.now();
                try {

                    KylinOrderTicketVo vo = mongoTemplate.findOne(
                            Query.query(Criteria.where("orderTicketsId").is(item.getOrderTicketsId())),
                            KylinOrderTicketVo.class,
                            KylinOrderTicketVo.class.getSimpleName());
                    if(vo.getStatus()!=0){
                        continue;
                    }

                    //mysql
                    KylinOrderTickets orderTickets = new KylinOrderTickets();
                    orderTickets.setOrderTicketsId(item.getOrderTicketsId());
                    orderTickets.setUpdatedAt(now);

                    KylinOrderTicketStatus orderTicketStatus = new KylinOrderTicketStatus();
                    orderTicketStatus.setOrderId(item.getOrderTicketsId());
                    orderTicketStatus.setStatus(KylinTableStatusConst.ORDER_STATUS2);
                    orderTicketStatus.setUpdatedAt(now);

                    //vo
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("status", KylinTableStatusConst.ORDER_STATUS2);
                    map.put("updatedAt", DateUtil.Formatter.yyyyMMddHHmmssSSS.format(now));
                    map.put("changeDate", now);
                    Document doc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                            Query.query(Criteria.where("orderTicketsId").is(orderTickets.getOrderTicketsId())).getQueryObject(),
                            new BasicDBObject("$set", mongoConverter.convertToMongoType(map)),
                            new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE)
                    );

                    KylinOrderTicketVo orderTicketVo = BsonUtil.toBean(doc, KylinOrderTicketVo.class);
                    LocalDateTime strTime = orderTicketVo.getChangeDate();

                    dataUtils.delOrderTicketRedis(orderTickets.getOrderTicketsId());
                    dataUtils.changeSurplusGeneral(item.getTicketId(), item.getNumber());
                    mongoVoUtils.resetOrderListVo(item.getUserId(), 2, item.getOrderTicketsId());

                    List<KylinOrderTicketEntities> entities = entitiesMapper.selectList(new UpdateWrapper<KylinOrderTicketEntities>().eq("order_id", item.getOrderTicketsId()));
                    for (int i = 0; i < entities.size(); i++) {
                        KylinOrderTicketEntities items = entities.get(i);
                        dataUtils.changeBuyInfo(items.getUserId(), items.getEnterIdCode(), items.getPerformanceId(), items.getTicketId(), -1);
                    }

                    sqls.add(SqlMapping.get("kylin_order_ticket.close"));
                    LinkedList<Object[]> sqlsDataA = new LinkedList<>();
                    sqlsDataA.add(orderTickets.getCloseOrderObject(strTime, strTime));

                    sqls.add(SqlMapping.get("kylin_order_ticket_status.close"));
                    LinkedList<Object[]> sqlsDataB = new LinkedList<>();
                    sqlsDataB.add(orderTicketStatus.getCloseOrderObject(strTime, strTime));

                    sqls.add(SqlMapping.get("kylin_order_ticket_relation.close"));
                    LinkedList<Object[]> sqlsDataC = new LinkedList<>();
                    sqlsDataC.add(new Object[]{orderTickets.getUpdatedAt(),orderTickets.getOrderTicketsId(),strTime, strTime});

                    rabbitTemplate.convertSendAndReceive(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE, MQConst.ROUTING_KEY_SQL_ORDER_CLOSE, SqlMapping.gets(sqls, sqlsDataA, sqlsDataB,sqlsDataC));

                } catch (Exception e) {
//                    lock.unlock();
                    e.printStackTrace();
                    return false;
                }
            } else {
//                lock.unlock();
            }
        }
        return true;
    }

    @Override
    public ResponseDto<Integer> checkOrderResult(String orderId) {
        KylinOrderTicketVo orderTicketData = dataUtils.getOrderTicketVo(orderId);
        if (orderTicketData == null) {
            return ResponseDto.failure("订单不存在");
        } else {
            String returnCheckData = HttpUtil.get(checkUrl + "?code=" + orderTicketData.getPayCode(), null);
            PayResultVo checkVo = JsonUtils.fromJson(returnCheckData, PayResultVo.class);
            if (checkVo.getStatus() == 1) {
                return ResponseDto.success(1);
            } else {
                return ResponseDto.success(0);
            }
        }
    }

    public boolean checkAgent(String agentId, KylinTicketVo ticketData) {
        boolean isAgent = ticketData.getIsAgent() == 1;
        if (isAgent) {
            return redisUtil.sHasKey(KylinRedisConst.AGENT, agentId);
        } else {
            return true;
        }
    }

    private boolean sycDamaiOrder(String orderId) {
        try {
            KylinOrderTicketVo orderData = dataUtils.getOrderTicketVo(orderId);
            KylinPerformanceVo vo = dataUtils.getPerformanceVo(orderData.getPerformanceId());
            TaobaoClient client = taobaoTicketUtils.initTaobaoClient();
            int isSysDamai = 0;
            for (int x = 0; x < vo.getTicketTimeList().size(); x++) {
                KylinTicketTimesVo timeItem = vo.getTicketTimeList().get(x);
                for (int y = 0; y < timeItem.getTicketList().size(); y++) {
                    KylinTicketVo ticketItem = timeItem.getTicketList().get(y);
                    if (ticketItem.getTicketsId().equals(orderData.getTicketId())) {
                        isSysDamai = ticketItem.getSysDamai();
                        break;
                    }
                }
            }
            if (isSysDamai == 1) {
                KylinOrderTicketVo orderVo = dataUtils.getOrderTicketVo(orderId);
                List<KylinOrderTicketEntitiesVo> listData = orderVo.getEntitiesVoList();
                AlibabaDamaiMevOpenBatchpushticketRequest req = new AlibabaDamaiMevOpenBatchpushticketRequest();
                List<AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam> list2 = new ArrayList<AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam>();
                for (int i = 0; i < listData.size(); i++) {
                    KylinOrderTicketEntitiesVo item = listData.get(i);
                    AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam obj3 = new AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam();
                    list2.add(obj3);
                    obj3.setUserName(item.getEnterName());//用户名 入场人姓名
                    obj3.setCertificateNo(item.getEnterIdCode());//证件号 入场人身份证
                    obj3.setOrderUserMobile(item.getEnterMobile());//用户手机号 入场人手机号
                    obj3.setCertificateType(item.getEnterType().longValue());//证件内容 入场人证件type
                    obj3.setPayTime(DateUtils.parseDate(orderData.getTimePay(), new String[]{"yyyy-MM-dd HH:mm:ss"}));//支付时间
                    obj3.setPerformId(item.getTimemId().longValue());//场次id
                    obj3.setTicketItemId(item.getTicketsmId().longValue());
                    obj3.setVoucherId(item.getMid().longValue());//票单号 入场人id

                    obj3.setOrderId(Long.parseLong(orderData.getOrderTicketsId()));//订单id orderId
                    obj3.setMediumType(orderData.getGetTicketType().equals("express") ? 1L : 2L);//票类型 快递 电子
                    obj3.setSupplierSecret(taobaoTicketUtils.getSupplierSecret());
                    obj3.setSystemId(taobaoTicketUtils.getSystemId());
                    obj3.setSeatType(1L);
                    obj3.setTicketType(1L);//票类型
                }
                req.setThirdTicketSetOpenParamList(list2);
                if (list2.size() == 0) {
                    return true;
                } else {
                    AlibabaDamaiMevOpenBatchpushticketResponse rsp = client.execute(req);
                    return rsp.getResult().getSuccess();
                }
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
