package com.liquidnet.client.admin.web.vo.adam.transaction;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.annotation.Excel.ColumnType;
import com.liquidnet.client.admin.common.annotation.Excel.Type;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel
public class AdamRechargeRecordVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @Excel(name = "id", type = Type.IMPORT)
    private String id;

    @ApiModelProperty("订单号")
    @Excel(name = "Transaction ID", cellType = ColumnType.NUMERIC, prompt = "订单号")
    private String transactionId;

    @ApiModelProperty("账号")
    @Excel(name = "Wallet No")
    private String walletNo;

    @ApiModelProperty("币种")
    @Excel(name = "Currency")
    private String currency;

    @ApiModelProperty("交易金额")
    @Excel(name = "Transaction Amount")
    private String transactionAmount;

    @ApiModelProperty("创建日期")
    @Excel(name = "Create Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String createDate;

    @ApiModelProperty("结束日期")
    @Excel(name = "Completed Date", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Type.EXPORT)
    private String completedDate;

    @ApiModelProperty("交易状态")
    @Excel(name = "Transaction Status", readConverterExp = "processing=Processing,failed=Failed,completed=Completed")
    private String transactionStatus;

    @ApiModelProperty("充值原因")
    @Excel(name = "Reanson")
    private String reason;

    @ApiModelProperty("充值说明")
    @Excel(name = "Reference")
    private String reference;

    @ApiModelProperty("错误描述")
    @Excel(name = "Error message")
    private String errorMessage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
