package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityDrawService;
import com.liquidnet.service.sweet.dto.SweetActivityDrawListDao;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityDrawListSearchParam;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityDrawMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-22
 */
@Service
public class SweetIntegralActivityDrawServiceImpl extends ServiceImpl<SweetIntegralActivityDrawMapper, SweetIntegralActivityDraw> implements ISweetIntegralActivityDrawService {

    @Autowired
    private SweetIntegralActivityDrawMapper sweetIntegralActivityDrawMapper;

    @Override
    public PageInfo<SweetIntegralActivityDraw> drawList(SweetIntegralActivityDrawListSearchParam listParam) {
        PageHelper.startPage(listParam.getPageNum(), listParam.getPageSize());
        List<SweetIntegralActivityDraw> sweetIntegralActivityDraws = sweetIntegralActivityDrawMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getIntegralActivityId, listParam.getIntegralActivityId())
        );
        return new PageInfo(sweetIntegralActivityDraws);
    }

    @Override
    public List<SweetActivityDrawListDao> selectExcelList(String integralActivityId) {
        List<SweetActivityDrawListDao> sweetIntegralActivityDraws = sweetIntegralActivityDrawMapper.selectExcelList(integralActivityId);
        return sweetIntegralActivityDraws;
    }

    @Override
    public Integer isOnline(String drawId) {
        SweetIntegralActivityDraw sweetIntegralActivityDraw = SweetIntegralActivityDraw.getNew();
        sweetIntegralActivityDraw.setReceivingStatus(2);
        sweetIntegralActivityDraw.setUpdatedAt(LocalDateTime.now());
        int update = sweetIntegralActivityDrawMapper.update(
                sweetIntegralActivityDraw,
                Wrappers.lambdaUpdate(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getDrawId, drawId)
        );
        // TODO: 2021/10/20 更新缓存
        return update;
    }
}
