/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handler;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandler;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.SSLHandshake;
import java.nio.ByteBuffer;

public class SSLStreamHandler
implements StreamHandler {
    private ByteBuffer sslUpstreamBuffer;
    private ByteBuffer sslDownstreamBuffer;
    private SSLHandshake handshake;

    public SSLStreamHandler(SSLHandshake handshake, int bufferSize) throws WebSocketException {
        this.handshake = handshake;
        this.sslUpstreamBuffer = ByteBuffer.allocate(bufferSize);
        this.sslDownstreamBuffer = ByteBuffer.allocate(bufferSize);
    }

    public void nextHandshakeUpstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        this.handshake.wrap(buffer, this.sslUpstreamBuffer);
        chain.nextHandshakeUpstreamHandler(ws, this.sslUpstreamBuffer);
    }

    public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        this.handshake.unwrap(buffer, this.sslDownstreamBuffer);
        chain.nextHandshakeDownstreamHandler(ws, this.sslDownstreamBuffer);
    }

    public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        this.handshake.wrap(buffer, this.sslUpstreamBuffer);
        chain.nextUpstreamHandler(ws, this.sslUpstreamBuffer, frame);
    }

    public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        this.handshake.unwrap(buffer, this.sslDownstreamBuffer);
        chain.nextDownstreamHandler(ws, this.sslDownstreamBuffer, frame);
    }
}

