package com.liquidnet.service.dragon.channel.alipay.config;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.util.Properties;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayUtil
 * @Package com.liquidnet.service.dragon.channel.alipay.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/9 15:20
 */
public class AlipayConfigUtil {

    private static final Log LOG = LogFactory.getLog(AlipayConfigUtil.class);

    /**
     * 通过静态代码块读取上传文件的验证格式配置文件,静态代码块只执行一次(单例)
     */
    private static Properties properties = new Properties();

    /**
     * 私有构造方法
     **/
    private AlipayConfigUtil() {
    }

    static {
        try {
            // 从类路径下读取属性文件
            properties.load(AlipayConfigUtil.class.getClassLoader()
                    .getResourceAsStream("alipay_config.properties"));
        } catch (IOException e) {
            LOG.error(e);
        }
    }

//↓↓↓↓↓↓↓↓↓↓请在这里配置您的基本信息↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓

    // 合作身份者ID，签约账号，以2088开头由16位纯数字组成的字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm
    public static final String partner = (String) properties.get("partner");

    // 收款支付宝账号，以2088开头由16位纯数字组成的字符串，一般情况下收款账号就是签约账号
    public static final String seller_id = (String) properties.get("seller_id");

    // MD5密钥，安全检验码，由数字和字母组成的32位字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm
    public static final String key = (String) properties.get("key");

    // 服务器异步通知页面路径  需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
    public static final String notify_url = (String) properties.get("notify_url");

    // 页面跳转同步通知页面路径 需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
    public static final String return_url = (String) properties.get("return_url");

    // 签名方式
    public static final String sign_type = (String) properties.get("sign_type");

    // 调试用，创建TXT日志文件夹路径，见AlipayCore.java类中的logResult(String sWord)打印方法。
    public static final String log_path = (String) properties.get("log_path");

    // 字符编码格式 目前支持 gbk 或 utf-8
    public static final String input_charset = (String) properties.get("input_charset");

    // 支付类型 ，无需修改
    public static final String payment_type = (String) properties.get("payment_type");

    // 调用的接口名，无需修改
    public static final String service = (String) properties.get("service");

    //支付宝被扫地址
    public static final String trade_pay_url = (String) properties.get("trade_pay_url");

    //支付宝交易查询地址
    public static final String trade_query_url = (String) properties.get("trade_query_url");

    //app_id
    public static final String app_id = (String) properties.get("app_id");

    //商户私钥
    public static final String mch_private_key = (String) properties.get("mch_private_key");

    //支付宝公钥
    public static final String ali_public_key = (String) properties.get("ali_public_key");

    // 防钓鱼时间戳  若要使用请调用类文件submit中的query_timestamp函数
    public static final String anti_phishing_key = "";

    // 客户端的IP地址 非局域网的外网IP地址，如：221.0.0.1
    public static final String exter_invoke_ip = "";

}

