package com.liquidnet.service.goblin.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * NFT兑换码表 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-19
 */
@Repository
public interface GoblinNftExCodeMapper extends BaseMapper<GoblinNftExCode> {

    /**
     * 批量添加兑换码信息
     *
     * @param goblinNftExCodes
     * @return
     */
    int addGoblinNftExCodes(@Param("goblinNftExCodes") List<GoblinNftExCode> goblinNftExCodes);

    /**
     * 根据活动ids查询
     *
     * @param activityIds
     * @return
     */
    List<GoblinNftExCode> selectByActivityIds(@Param("activityIds") String activityIds);


    /**
     * 条件查询 兑换码
     *
     * @param goblinNftExCode
     * @return
     */
    List<GoblinNftExCode> selectGoblinNftCode(GoblinNftExCode goblinNftExCode);

    /**
     * 根据codeIds 获取
     *
     * @param codeIds
     * @return
     */
    List<GoblinNftExCode> selectByIds(@Param("codeIds") String codeIds);

    /**
     * 批量修改
     *
     * @param goblinNftExCodes
     * @return
     */
    int updateCodes(@Param("goblinNftExCodes") List<GoblinNftExCode> goblinNftExCodes);

    /*
     * 根据code获取兑换码信息
     */
    GoblinNftExCode selectGoblinNftCodeByCode(@Param("code") String code);

    /*
     * 获取数量
     */
    int selectGoblinNftCodeCount(GoblinNftExCode goblinNftExCode);

    /**
     * 修改操作用户
     * @param goblinNftExCode
     * @return
     */
    int updateCodeAdminUid(GoblinNftExCode goblinNftExCode);

    /**
     * 根据活动id获取可用的兑换码
     * @param activityId
     * @return
     */
    List<GoblinNftExCode> selectCodeAvailableByActivityId(@Param("activityId") String activityId);

}
