package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinBackOrderDetailsVo;
import com.liquidnet.service.goblin.dto.vo.GoblinBackOrderVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreBackOrderListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import com.liquidnet.service.goblin.param.RefundCallbackParam;

import java.math.BigDecimal;

public interface IGoblinStoreBackOrderService {
    ResponseDto<PageInfo<GoblinStoreBackOrderListVo>> orderBackList(Integer page,
                                                                    String orderBackCode,
                                                                    Integer type,
                                                                    String cst,
                                                                    String cet,
                                                                    String orderCode,
                                                                    String spuName,
                                                                    Integer status);

    ResponseDto<GoblinBackOrderDetailsVo> orderDetails(String backOrderId);

    ResponseDto<Boolean> changeExpressRefund(String backOrderId, BigDecimal refundPrice);

    ResponseDto<Boolean> changeSkuRefund(String backOrderId, BigDecimal refundPrice, String orderSkuId);
}
