package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseCommonParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiCommonParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfZhengzaiSkuVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStorePurchaseSkuVo;

import java.util.List;

public interface IGoblinZhengzaiService {

     List<GoblinSelfMarketingVo> zhengzaiCanJoin(String storeId);

     GoblinSelfMarketingVo zhengzaiCanJoinDetails(String marketId,String storeId);

     /**
      * 获取活动内spu列表
      *
      * @param marketId 活动秒杀id
      * @param page     页数
      * @return
      */
     ResponseDto<PageInfo<GoblinMarketSpuListVo>> zhengzaiSpuList(String marketId, String storeId, int page);

     /**
      * 获取活动内sku列表
      *
      * @param selfMarketId 正在下单id
      * @return
      */
     ResponseDto<List<GoblinSelfZhengzaiSkuVo>> zhengzaiSkuList(String selfMarketId, String storeId, String spuId);

     /**
      * 添加活动相关sku
      *
      * @param params
      * @return
      */
     ResponseDto<Boolean> zhengzaiSkuInsert(GoblinStoreZhengzaiCommonParam params);

     /**
      * 编辑活动相关sku
      *
      * @param params
      * @return
      */
     ResponseDto<Boolean> zhengzaiSkuUpdate(GoblinStoreZhengzaiCommonParam params);

     /**
      * 删除活动内sku
      *
      * @param marketId 活动秒杀id
      * @param spuId    spuId
      * @return
      */
     ResponseDto<Boolean> zhengzaiSpuDel(String marketId, String storeId, String spuId);
}
