package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.mapper.AdamRealNameMapper;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.base.SqlMapping;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 实名信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamRealNameServiceImpl extends ServiceImpl<AdamRealNameMapper, AdamRealName> implements IAdamRealNameService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    RabbitTemplate rabbitTemplate;

    @Override
    public AdamRealInfoVo queryByUid(String uid) {
        AdamRealInfoVo realInfoVo = (AdamRealInfoVo) redisUtil.hget(AdamRedisConst.INFO_REAL_NAME, uid);
        if (null == realInfoVo) {
            realInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamRealInfoVo.class, AdamRealInfoVo.class.getSimpleName());

            if (null != realInfoVo) redisUtil.hset(AdamRedisConst.INFO_REAL_NAME, uid, realInfoVo);
        }
        return realInfoVo;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void add(AdamRealName realName) {
        mongoTemplate.insert(realName, AdamRealInfoVo.class.getSimpleName());

        List<Object> paramList = Arrays.asList(
                realName.getRealNameId(),
                realName.getUid(),
                realName.getType(),
                realName.getName(),
                realName.getIdCard(),
                realName.getState(),
                realName.getCreatedAt()
        );
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_real_name.add", paramList.toArray()));
    }
}
