package com.liquidnet.service.sweet.service.impl.syncRedis;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;
import java.util.List;

@Slf4j
@Service
public class UserDataServiceImpl {
    @Autowired
    WechatMpConfigure wechatMpConfigure;

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    private QueueUtils queueUtils;

    public void userInfo(Integer type) throws WxErrorException {
        WxMpService wxMpService = wechatMpConfigure.getWxMpService(type);

        String nextOpenid = "";
        do {
            WxMpUserList wxMpUserList = wxMpService.getUserService().userList(nextOpenid);
            int count = wxMpUserList.getCount();
            long total = wxMpUserList.getTotal();
            List<String> openids = wxMpUserList.getOpenids();
            nextOpenid = wxMpUserList.getNextOpenid();
            log.info("count：[{}] ", count);
            log.info("total：[{}] ", total);
//            log.info("openids：[{}] ", openids);
            log.info("nextOpenid：[{}] ", nextOpenid);

            for (String openId : openids) {
                try {
                    WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
                    if (!wxMpUser.getSubscribe()) {
                        log.info("getSubscribeFalse：openId：[{}]", openId);
                        continue;
                    }
                    SweetWechatUsersVo sweetWechatUsers = redisUtils.getSweetWechatUsers(wxMpUser.getUnionId(), type);
                    if (null == sweetWechatUsers) {
                        SweetWechatUsersVo sweetWechatUsersVo = SweetWechatUsersVo.getNew();
                        sweetWechatUsersVo.setWechatUserId(IDGenerator.nextSnowId());
                        sweetWechatUsersVo.setType(type);
                        sweetWechatUsersVo.setOpenId(wxMpUser.getOpenId());
                        sweetWechatUsersVo.setUnionId(wxMpUser.getUnionId());
                        sweetWechatUsersVo.setNickname(wxMpUser.getNickname());
                        sweetWechatUsersVo.setSexDesc(wxMpUser.getSexDesc());
                        sweetWechatUsersVo.setSex(wxMpUser.getSex());
                        sweetWechatUsersVo.setHeadImgUrl(wxMpUser.getHeadImgUrl());
                        sweetWechatUsersVo.setLanguage(wxMpUser.getLanguage());
                        sweetWechatUsersVo.setCountry(wxMpUser.getCountry());
                        sweetWechatUsersVo.setProvince(wxMpUser.getProvince());
                        sweetWechatUsersVo.setCity(wxMpUser.getCity());
                        sweetWechatUsersVo.setSubscribeTime(DateUtil.ofEpochMilli(wxMpUser.getSubscribeTime()));
                        sweetWechatUsersVo.setSubscribeScene(wxMpUser.getSubscribeScene());

                        LinkedList<String> sqls = CollectionUtil.linkedListString();
                        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                        sqls.add(SqlMapping.get("sweet_wechat_users.insert"));
                        sqlsDataA.add(new Object[]{
                                sweetWechatUsersVo.getWechatUserId(), type, sweetWechatUsersVo.getOpenId(), sweetWechatUsersVo.getUnionId(), sweetWechatUsersVo.getNickname(),
                                sweetWechatUsersVo.getSexDesc(), sweetWechatUsersVo.getSex(), sweetWechatUsersVo.getHeadImgUrl(), sweetWechatUsersVo.getLanguage(),
                                sweetWechatUsersVo.getCountry(), sweetWechatUsersVo.getProvince(), sweetWechatUsersVo.getCity(),
                                sweetWechatUsersVo.getSubscribeTime(), sweetWechatUsersVo.getSubscribeScene()
                        });
                        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_USER_INSERT.getKey(),
                                SqlMapping.gets(sqls, sqlsDataA));
                        // 入缓存
                        redisUtils.setSweetWechatUsers(sweetWechatUsersVo);
                    }

                } catch (Exception e) {
                    log.info("forException：openId：[{}]", openId);
                }
            }
            log.info("nextOpenidSuccess：[{}] ", nextOpenid);
        } while (!nextOpenid.isEmpty());
        log.info("同步微信用户完成");
    }

    public void getUser(String openId, Integer type) throws WxErrorException {
        WxMpService wxMpService = wechatMpConfigure.getWxMpService(type);
        WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
        log.info("openId：[{}],wxMpUsers：[{}]", openId, wxMpUser);

        SweetWechatUsersVo sweetWechatUsers = redisUtils.getSweetWechatUsers(wxMpUser.getUnionId(), type);
        if (null == sweetWechatUsers) {
            SweetWechatUsersVo sweetWechatUsersVo = SweetWechatUsersVo.getNew();
            sweetWechatUsersVo.setWechatUserId(IDGenerator.nextSnowId());
            sweetWechatUsersVo.setType(type);
            sweetWechatUsersVo.setOpenId(wxMpUser.getOpenId());
            sweetWechatUsersVo.setUnionId(wxMpUser.getUnionId());
            sweetWechatUsersVo.setNickname(wxMpUser.getNickname());
            sweetWechatUsersVo.setSexDesc(wxMpUser.getSexDesc());
            sweetWechatUsersVo.setSex(wxMpUser.getSex());
            sweetWechatUsersVo.setHeadImgUrl(wxMpUser.getHeadImgUrl());
            sweetWechatUsersVo.setLanguage(wxMpUser.getLanguage());
            sweetWechatUsersVo.setCountry(wxMpUser.getCountry());
            sweetWechatUsersVo.setProvince(wxMpUser.getProvince());
            sweetWechatUsersVo.setCity(wxMpUser.getCity());
            sweetWechatUsersVo.setSubscribeTime(DateUtil.ofEpochMilli(wxMpUser.getSubscribeTime()));
            sweetWechatUsersVo.setSubscribeScene(wxMpUser.getSubscribeScene());

            LinkedList<String> sqls = CollectionUtil.linkedListString();
            LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
            sqls.add(SqlMapping.get("sweet_wechat_users.insert"));
            sqlsDataA.add(new Object[]{
                    sweetWechatUsersVo.getWechatUserId(), type, sweetWechatUsersVo.getOpenId(), sweetWechatUsersVo.getUnionId(), sweetWechatUsersVo.getNickname(),
                    sweetWechatUsersVo.getSexDesc(), sweetWechatUsersVo.getSex(), sweetWechatUsersVo.getHeadImgUrl(), sweetWechatUsersVo.getLanguage(),
                    sweetWechatUsersVo.getCountry(), sweetWechatUsersVo.getProvince(), sweetWechatUsersVo.getCity(),
                    sweetWechatUsersVo.getSubscribeTime(), sweetWechatUsersVo.getSubscribeScene()
            });
            queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_USER_INSERT.getKey(),
                    SqlMapping.gets(sqls, sqlsDataA));
            // 入缓存
            redisUtils.setSweetWechatUsers(sweetWechatUsersVo);
        }
    }
}
