package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 可参加官方活动的店铺表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMarketingZhengzaiRelation implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 官方营销表id
     */
    private String selfMarketId;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 可显示时间
     */
    private LocalDateTime showTime;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private Integer delTag;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinMarketingZhengzaiRelation obj = new GoblinMarketingZhengzaiRelation();

    public static GoblinMarketingZhengzaiRelation getNew() {
        try {
            return (GoblinMarketingZhengzaiRelation) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMarketingZhengzaiRelation();
        }
    }
}
