package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberCodeAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberPriceAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberRightsAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.param.admin.AdamMemberBuildParam;
import com.liquidnet.service.adam.dto.param.admin.AdamMemberRightsBuildParam;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.entity.AdamMemberRights;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.admin.CandyMemberCouponBuildParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponMemberDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;

@Api(tags = "登登登会员")
@Controller
@RequestMapping("adam/member/detail")
public class AdamMemberAdminController extends BaseController {
    private final String prefix = "zhengzai/adam/member/detail";
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberRightsAdminService adamMemberRightsAdminService;
    @Autowired
    IAdamMemberPriceAdminService adamMemberPriceAdminService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;
    @Autowired
    ICandyMgtCouponAdminService candyMgtCouponAdminService;
    @Autowired
    RedisUtil redisUtil;

    @RequiresPermissions("adam:member:detail:view")
    @GetMapping()
    public String detailInfo(ModelMap mmap) {
        AdamMember member = adamMemberService.getOne(Wrappers.lambdaQuery(AdamMember.class)
                .eq(AdamMember::getState, 1)
                .select(
                        AdamMember::getMemberId,
                        AdamMember::getName,
                        AdamMember::getTitle,
                        AdamMember::getSubTitle,
                        AdamMember::getAvatar,
                        AdamMember::getIcon,
                        AdamMember::getLimitation,
                        AdamMember::getLimitStart,
                        AdamMember::getLimitEnd,
                        AdamMember::getInterestsDetail,
                        AdamMember::getNotes,
                        AdamMember::getType,
                        AdamMember::getIntegralRate
                )
        );
        mmap.put("member", member);

        if (null != member) {
            List<AdamMemberRights> memberRightsList = adamMemberRightsAdminService.list(Wrappers.lambdaQuery(AdamMemberRights.class)
                    .eq(AdamMemberRights::getState, 1)
                    .eq(AdamMemberRights::getMemberId, member.getMemberId())
                    .select(
                            AdamMemberRights::getMrightsId,
                            AdamMemberRights::getCover,
                            AdamMemberRights::getTitle,
                            AdamMemberRights::getSubTitle,
                            AdamMemberRights::getDetail
                    )
            );
            mmap.put("memberRightsList", memberRightsList);

            if (!CollectionUtils.isEmpty(memberRightsList)) {
                List<String> mrightsIdList = memberRightsList.stream().map(AdamMemberRights::getMrightsId).collect(Collectors.toList());

                List<CandyMgtCouponMemberDto> couponMemberDtoList = candyMgtCouponAdminService.listForMgtCouponMemberDto(mrightsIdList);

                mmap.put("couponMemberDtoList", couponMemberDtoList);
            }

            AdamMemberPrice memberPrice = adamMemberPriceAdminService.getOne(Wrappers.lambdaQuery(AdamMemberPrice.class)
                    .eq(AdamMemberPrice::getState, 1)
                    .eq(AdamMemberPrice::getMemberId, member.getMemberId())
                    .select(
                            AdamMemberPrice::getMemberPriceId,
                            AdamMemberPrice::getPrice,
                            AdamMemberPrice::getPriceFixed,
                            AdamMemberPrice::getPriceSpecial,
                            AdamMemberPrice::getDays
                    )
            );
            mmap.put("memberPrice", memberPrice);
        }
        return prefix + "/info";
    }

    @ApiOperation(value = "会员设置:基础信息编辑")
    @RequiresPermissions("adam:member:detail:edit")
    @PostMapping("edit")
    @ResponseBody
    public AjaxResult detailInfoEdit(AdamMemberBuildParam parameter) {
        return this.toAjax(adamMemberService.edit(parameter));
    }

    @ApiOperation(value = "会员套餐:权益编辑")
    @RequiresPermissions("adam:member:detail:rights:edit")
    @PostMapping("rights_edit")
    @ResponseBody
    public AjaxResult detailRightEdit(AdamMemberRightsBuildParam parameter) {
        return this.toAjax(true);
    }

    @ApiOperation(value = "会员套餐:券编辑")
    @RequiresPermissions("adam:member:detail:coupon:edit")
    @PostMapping("coupon_edit")
    @ResponseBody
    public AjaxResult detailCouponEdit(CandyMemberCouponBuildParam parameter) {
        return this.toAjax(true);
    }

    @ApiOperation(value = "会员码:列表")
    @RequiresPermissions("adam:member:detail:code:list")
    @PostMapping("code_list")
    @ResponseBody
    public AjaxResult detailCodeList() {
        return this.toAjax(true);
    }

    @ApiOperation(value = "会员码:生成")
    @RequiresPermissions("adam:member:detail:code:gen")
    @PostMapping("code_gen")
    @ResponseBody
    public AjaxResult detailCodeGen() {
        return this.toAjax(true);
    }


//    @Log(title = "会员信息", businessType = BusinessType.LIST)
//    @RequiresPermissions("adam:member:list")
//    @ApiOperation(value = "会员卡列表")
//    @PostMapping("list")
//    public ResponseDto<List<AdamMemberVo>> list() {
//        List<AdamMember> list = adamMemberService.list(
//                Wrappers.lambdaQuery(AdamMember.class).select(
//                        AdamMember::getMemberId, AdamMember::getName, AdamMember::getTitle, AdamMember::getType, AdamMember::getState
//                )
//        );
//        List<AdamMemberVo> vos = new ArrayList<>();
//        list.forEach(r -> {
//            vos.add(AdamMemberVo.getNew().copy(r));
//        });
//        return ResponseDto.success(vos);
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.INSERT)
//    @RequiresPermissions("adam:member:add")
//    @ApiOperation(value = "添加会员卡")
//    @PostMapping("add")
//    public ResponseDto<Object> add(@Valid @RequestBody AdamMemberParam parameter) {
//        adamMemberService.add(parameter);
//        return ResponseDto.success();
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.DETAIL)
//    @RequiresPermissions("adam:member:info")
//    @ApiOperation(value = "会员卡详情")
//    @PostMapping("info")
//    public ResponseDto<Object> info(@NotBlank(message = "会员类型ID不能为空") @RequestParam String memberId) {
//        return ResponseDto.success(adamMemberService.getOne(
//                Wrappers.lambdaQuery(AdamMember.class).eq(AdamMember::getMemberId, memberId)
//        ));
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.UPDATE)
//    @RequiresPermissions("adam:member:edit")
//    @ApiOperation(value = "会员卡编辑")
//    @PostMapping("edit")
//    public ResponseDto<Object> edit(@Valid @RequestBody AdamMemberParam parameter) {
//        adamMemberService.edit(parameter);
//        return ResponseDto.success();
//    }

    @Log(title = "会员信息", businessType = BusinessType.MEMBER_GEN_CODE)
    @RequiresPermissions("adam:member:gen_code")
    @ApiOperation(value = "生成兑换码")
    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@Valid @RequestBody AdamMemberCodeParam parameter) {
        if (1 != parameter.getType()) {
            return ResponseDto.failure("参数有误[TYPE]");
        }
        int count = adamMemberPriceAdminService.count(
                Wrappers.lambdaQuery(AdamMemberPrice.class)
                        .eq(AdamMemberPrice::getMemberPriceId, parameter.getMemberPriceId())
                        .eq(AdamMemberPrice::getMemberId, parameter.getMemberId())
                        .eq(AdamMemberPrice::getState, 1)
        );
        if (count <= 0) {
            return ResponseDto.failure("会员卡ID/价格ID无效");
        }
        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }
}
