package com.liquidnet.client.admin.zhengzai.candy.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.candy.entity.CandyCouponCode;
import lombok.Data;

import java.io.Serializable;

@Data
public class CandyCouponCodeExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 2420844668059161869L;
    @Excel(name = "券码")
    private String ccode;
    @Excel(name = "券码")
    private String redeemMobile;
    @Excel(name = "状态")
    private String state;
    @Excel(name = "批次号")
    private String couponId;

    private static final CandyCouponCodeExcelDto obj = new CandyCouponCodeExcelDto();

    public static CandyCouponCodeExcelDto getNew() {
        try {
            return (CandyCouponCodeExcelDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponCodeExcelDto();
        }
    }

    public CandyCouponCodeExcelDto copy(CandyCouponCode source) {
        if (null == source) return this;
        this.setCcode(source.getCcode());
        this.setRedeemMobile(source.getRedeemMobile());
        switch (source.getState()) {
            case 0:
                this.setState("未使用");
                break;
            case 1:
                this.setState("已使用");
                break;
            case 2:
                this.setState("失效");
                break;
            case 3:
                this.setState("退回");
                break;
            default:
                this.setState(String.valueOf(source.getState()));
                break;
        }
        this.setCouponId(source.getCouponId());
        return this;
    }
}
