package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 推荐活动关联表
 * </p>
 * @since 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRecommendActiveRelationVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "mid")
    private Long mid;

    /**
     * 推荐活动关系id
     */
    @ApiModelProperty(value = "推荐活动关系id")
    private String recommendRelationId;

    /**
     * 推荐商品id
     */
    @ApiModelProperty(value = "推荐商品id")
    private String recommendBindId;

    /**
     * 1NFT2组合购3演出4商品
     */
    @ApiModelProperty(value = "1NFT2组合购3演出4商品")
    private Integer type;

    /**
     * 推荐活动id(关联id)
     */
    @ApiModelProperty(value = "推荐活动id(关联id)")
    private String recommendActiveId;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "推荐活动id(关联id)")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "推荐活动id(关联id)")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer indexs;

    @ApiModelProperty(value = "演出的vo")
    private KylinPerformanceVo kylinPerformanceVo;

    private static final KylinRecommendActiveRelationVo obj = new KylinRecommendActiveRelationVo();
    public static KylinRecommendActiveRelationVo getNew() {
        try {
            return (KylinRecommendActiveRelationVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinRecommendActiveRelationVo();
        }
    }



}
