package com.liquidnet.service.consumer.nft.service.processor;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyRespDto;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperTradeCommonBiz;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinTradeCommonBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerJsonNftPublishAndBuyProcessor
 * @Package com.liquidnet.service.consumer.nft.service.processor
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/29 17:04
 */
@Slf4j
@Component
public class ConsumerGalaxyJsonNftPublishAndBuyProcessor {
    @Autowired
    private ZxinTradeCommonBiz zxinTradeCommonBiz;

    @Autowired
    private XuperTradeCommonBiz xuperTradeCommonBiz;
    /**
     * 执行购买处理
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        if(reqDto.getRouterType().equalsIgnoreCase(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode())){
            return zxinTradeCommonBiz.nftPublishAndBuy(reqDto);
        }else if(reqDto.getRouterType().equalsIgnoreCase(GalaxyEnum.RouterTypeEnum.XUPER.getCode())){
            return xuperTradeCommonBiz.nftPublishAndBuy(reqDto);
        }else{
            log.error("nftPublishAndBuy 区块链路由类型不存在 routerType : {}",reqDto.getRouterType());
            return ResponseDto.failure();
        }
    }
}
