package com.liquidnet.service.kylin.dto.param;

import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
public class PerformancePartnerListParam {
    @ApiModelProperty(value = "第三方用户id", example = "1")
    private String merchantId;
    @ApiModelProperty(value = "演出名称", example = "")
    private String title;
    @ApiModelProperty(value = "-2全部(不包括未提交)0未发布演出列表;3审核通过;6上线;7下架;8已结束;", example = "0")
    @NotNull(message = "演出状态不能为空")
    private Integer status;
    @ApiModelProperty(value = "-2全部,-1未提交审核，0审核中，1审核通过，2审核拒绝", example = "0")
    @NotNull(message = "审核状态不能为空")
    private Integer auditStatus;
    @ApiModelProperty(value = "演出开始时间", example = "2000-01-01 12:00:00")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间", example = "2000-01-01 12:00:00")
    private String timeEnd;
    @ApiModelProperty(value = "排序类型 1创建时间倒序 2创建时间正序 3演出时间倒序 4演出时间正序", example = "0")
    @NotNull(message = "排序类型不能为空")
    private Integer orderType;
    @ApiModelProperty(value = "停售时间(单位天 -2全部)", example = "-2")
    private long stopSellDay;
    @ApiModelProperty(value = "停售时间(单位天 -2全部)", example = "-2", hidden = true)
    private String stopSellTime;
    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer page;
    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer size;
    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;
    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
        switch (orderType) {
            case 1: {
                orderItem = "createdAt";
                orderSc = "desc";
                break;
            }
            case 2: {
                orderItem = "createdAt";
                orderSc = "asc";
                break;
            }
            case 3: {
                orderItem = "timeStart";
                orderSc = "desc";
                break;
            }
            case 4: {
                orderItem = "timeStart";
                orderSc = "asc";
                break;
            }

        }
    }

    public void setStopSellDay(Long stopSellDay) {
        this.stopSellDay=stopSellDay;
        LocalDateTime now = LocalDateTime.now();
        this.stopSellTime =
                DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(now.plusDays(-stopSellDay));
    }
}
