package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.merchant.entity.MerchantFieldCheckers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "MerchantFieldAppliesVo", description = "场地默认验票员")
@Data
public class MerchantFieldCheckersVo implements java.io.Serializable, Cloneable  {
    private static final long serialVersionUID = 5965779904967405763L;

    @ApiModelProperty(position = 10, value = "验票授权ID")
    private String fieldCheckerId;

    @ApiModelProperty(position = 11, value = "场地ID")
    private String fieldId;

    @ApiModelProperty(position = 12, value = "权利账号")
    private String uid;

    @ApiModelProperty(position = 13, value = "手机号")
    private String mobile;

    @ApiModelProperty(position = 14, value = "姓名")
    private String name;

    @ApiModelProperty(position = 15, value = "授权账号")
    private String cuid;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;


    private static final MerchantFieldCheckersVo obj = new MerchantFieldCheckersVo();

    public static MerchantFieldCheckersVo getNew() {
        try {
            return (MerchantFieldCheckersVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantFieldCheckersVo();
    }

    public MerchantFieldCheckersVo copy(MerchantFieldCheckers source) {
        if (null == source) return this;

        this.setFieldCheckerId(source.getFieldCheckerId());
        this.setFieldId(source.getFieldId());
        this.setUid(source.getUid());
        this.setMobile(source.getMobile());
        this.setName(source.getName());
        this.setCuid(source.getCuid());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setDeletedAt(source.getDeletedAt());

        return this;
    }

}
