package com.liquidnet.service.dragon.channel.alipay.strategy.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.channel.alipay.biz.AlipayBiz;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.strategy.IAlipayStrategy;
import com.liquidnet.service.dragon.channel.alipay.util.AlipayUtil;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AbstractAlipayStrategy
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/12 12:36
 */
@Slf4j
public abstract class AbstractAlipayStrategy implements IAlipayStrategy {
    @Autowired
    private AlipayBiz alipayBiz;

    protected String productCode = "QUICK_WAP_PAY";

    @Override
    public ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        //设置productCode
        setProductCode();

        AlipayTradePayReq alipayTradePayReq = new AlipayTradePayReq();
        log.info("子类 productCode:{}",this.productCode);
        alipayTradePayReq.setProductCode(this.productCode);
        alipayTradePayReq.setTotalAmount(dragonPayBaseReqDto.getPrice());
        alipayTradePayReq.setSubject(dragonPayBaseReqDto.getName());
        alipayTradePayReq.setBody(dragonPayBaseReqDto.getDetail());
        //dragon中支付编号
        alipayTradePayReq.setOutTradeNo(dragonPayBaseReqDto.getCode());
        alipayTradePayReq.setTimeExpire(dragonPayBaseReqDto.getExpireTime());
        //调用支付
        Map<String, Object> result = AlipayUtil.tradeWapPay(alipayTradePayReq);
        //拼接返回参数
        DragonPayBaseRespDto respDto = buildCommonRespDto(dragonPayBaseReqDto);
        respDto = this.buildResponseDto(respDto,result);

        //支付订单持久化
        alipayBiz.buildPayOrders(dragonPayBaseReqDto,respDto);
        return ResponseDto.success(respDto);
    }

    /**
     * 设置productCode
     */
    protected abstract void setProductCode();

    /**
     * 构造公共返回参数
     * @param dragonPayBaseReqDto
     * @return
     */
    protected DragonPayBaseRespDto buildCommonRespDto(DragonPayBaseReqDto dragonPayBaseReqDto){
        DragonPayBaseRespDto respDto = new DragonPayBaseRespDto();
        respDto.setCode(dragonPayBaseReqDto.getCode());
        respDto.setOrderCode(dragonPayBaseReqDto.getOrderCode());
        DragonPayBaseRespDto.PayData payData = new DragonPayBaseRespDto.PayData();
        respDto.setPayData(payData);
        return respDto;
    }

    /**
     * 构造返回参数
     */
    abstract DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto,Map<String, Object> respResult);

}
