package com.liquidnet.service.dragon.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayNotifyController
 * @Package com.liquidnet.service.dragon.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/11 23:35
 */
@RestController
@RequestMapping("pay")
public class PayNotifyController {
    /**
     * 支付宝支付回调
     * @return
     */
    @PostMapping("/notify/alipay")
    @ApiOperation("支付宝支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay")
    })
    public ResponseDto<DragonPayBaseRespDto> notifyAlipay(
            @RequestParam(value = "payType") @NotNull(message = "支付类型不能为空") String payType){
        return null;
    }
    /**
     * 微信支付回调
     * @return
     */
    @PostMapping("/notify/wepay")
    @ApiOperation("支付宝支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay")
    })
    public ResponseDto<DragonPayBaseRespDto> notifyWepay(
            @RequestParam(value = "payType") @NotNull(message = "支付类型不能为空") String payType){
        return null;
    }
}
