package com.liquidnet.service.erp.constant;

public class ErpEnum {
    /**
     * 旺店通API
     * https://open.wangdian.cn/open/apidoc
     */
    public enum WdtAPI {
        /**
         * 增量查询库存
         */
        STOCK_QUERY("stock_query.php"),
        /**
         * 创建原始订单
         * 建议每间隔（5~10）分钟，将商城积累的订单集中推送，每次请求包含订单条数建议不超过50条(1条订单由“trade_list+order_list”构成)，如果累积量超过了50条，分多次请求。
         */
        TRADE_PUSH("trade_push.php"),
        /**
         * 查询物流同步
         * 查询后需要调用 logistics_sync_ack 应答
         */
        logistics_sync_query("logistics_sync_query.php"),
        /**
         * 物流同步回写
         * 查询后需要调用 logistics_sync_ack 应答
         */
        logistics_sync_ack("logistics_sync_ack.php"),
        /**
         * 查询库存同步
         * 建议间隔时间3~5分钟查询一次，集中获取待同步数据，注意上一次回写完成以后，再从数据池获取待同步的数据。 查询后需要调用 api_goods_stock_change_ack 应答
         */
        api_goods_stock_change_query("api_goods_stock_change_query.php"),
        /**
         * 库存同步回写
         * 查询后需要调用 api_goods_stock_change_ack 应答
         */
        api_goods_stock_change_ack("api_goods_stock_change_ack.php"),
        ;
        private final String uri;

        WdtAPI(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return uri;
        }
    }
}
