package com.liquidnet.service.platform.service.impl.stone;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.feign.stone.api.FeignStoneIntegralClient;
import com.liquidnet.service.stone.dto.StoneInvalidDto;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.entity.StoneScoreUser;
import com.liquidnet.service.stone.entity.TempScore;
import com.liquidnet.service.stone.mapper.StoneScoreLogsMapper;
import com.liquidnet.service.stone.mapper.StoneScoreUserMapper;
import com.liquidnet.service.stone.mapper.TempScoreMapper;
import com.liquidnet.service.stone.vo.StoneUserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;


@Service
@Slf4j
public class StoneServerImpl {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    StoneScoreUserMapper stoneScoreUserMapper;
    @Autowired
    StoneScoreLogsMapper stoneScoreLogsMapper;
    @Autowired
    FeignStoneIntegralClient stoneIntegralClient;
    @Autowired
    TempScoreMapper tempScoreMapper;

    public boolean refreshScore(String time) {
        //获取需要跑积分的用户
        LocalDate et = LocalDate.parse(time);
        LocalDate st = et.minusYears(1);
        int year = et.getYear();
        String strTime = year + "年积分过期";
        List<StoneInvalidDto> logsList = stoneScoreLogsMapper.getInvalidScore(st, et, strTime);
        for (StoneInvalidDto logs : logsList) {
            stoneIntegralClient.de2111(logs.getUid(), new BigDecimal(logs.getInvalidScore() + "").intValue(), strTime);
        }
        return true;
    }

    public boolean initScore(String uid) {
        try {
            TempScore dataBean = tempScoreMapper.selectOne(Wrappers.lambdaQuery(TempScore.class).eq(TempScore::getUid, uid));
            int score = dataBean.getPriceCost().intValue();
            int isLog = stoneScoreLogsMapper.selectCount(Wrappers.lambdaQuery(StoneScoreLogs.class).eq(StoneScoreLogs::getUid, uid).eq(StoneScoreLogs::getContent, "历史积分"));
            if (isLog > 0) {
                return true;
            }
            //创建 用户积分数据
            int isExists = stoneScoreUserMapper.selectCount(Wrappers.lambdaQuery(StoneScoreUser.class).eq(StoneScoreUser::getUid, uid));
            if (isExists <= 0) {
                StoneScoreUser data = StoneScoreUser.getNew();
                data.setStatus(1);
                data.setScoreId(IDGenerator.nextTimeId2());
                data.setUid(uid);
                data.setCreatedAt(LocalDateTime.now());
                stoneScoreUserMapper.insert(data);
                StoneUserVo userTaskVo = StoneUserVo.getNew();
                userTaskVo.getTask();
                userTaskVo.setUid(uid);
                userTaskVo.setStatus(1);
                userCreate(userTaskVo);
            }
            stoneIntegralClient.in2111(uid, score, "历史积分");
        } catch (Exception e) {
            log.info("异常 : {} ", e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /**
     * 创建 用户积分
     *
     * @param data
     * @return
     */
    private Object userCreate(StoneUserVo data) {
        return mongoTemplate.insert(data, StoneUserVo.class.getSimpleName());
    }
}
