package com.liquidnet.service.feign.goblin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(
        name = "liquidnet-service-goblin",
        contextId = "FeignGoblinErpTaskClient",
        path = "goblin",
        url = "${liquidnet.service.goblin.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignGoblinErpTaskClient {


    @PostMapping("wdt/syncErpSpuStock")
    ResponseDto<Boolean> syncErpSpuStock(@RequestParam("spuId") String spuId, @RequestParam("min") Integer min);

    @PostMapping("wdt/pushErpTrade")
    ResponseDto<Boolean> pushErpTrade();

    @PostMapping("wdt/syncErpLogistic")
    ResponseDto<Boolean> syncErpLogistic();

}
